/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.GenerationException;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.SqlParameterInfo;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class SqlProcessor {
    private ClassInfo classInfo_;

    public SqlProcessor(ClassInfo classInfo, ArtifactOptionsSet artifactOptionsSet) {
        this.classInfo_ = classInfo;
    }

    public void processSql() {
        List<MethodInfo> list = this.classInfo_.getListOfMethods();
        if (list == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NOMETH", this.classInfo_.getTypeName()), null, 10232, null, null);
        }
        for (MethodInfo methodInfo : list) {
            this.processMethod(methodInfo);
        }
    }

    private void processMethod(MethodInfo methodInfo) {
        ParameterInfoArray parameterInfoArray = new ParameterInfoArray();
        methodInfo.setParameterInfoArray(parameterInfoArray);
        String string = methodInfo.getSql();
        if (string == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NOANNOT", methodInfo.getMethodNameAndParameterTypesString()), null, 10184, null, methodInfo);
        }
        String string2 = this.processSql(methodInfo.getSql(), parameterInfoArray, methodInfo);
        methodInfo.setSqlStatementType(this.getSqlStatementType(methodInfo.getSql(), parameterInfoArray, methodInfo));
        methodInfo.setProcessedSql(string2);
        methodInfo.setEscapedProcessedSql(this.getEscapedProcessedSql(string2, methodInfo));
        this.processUpdateConcurrency(methodInfo);
    }

    private String processSql(String string, ParameterInfoArray parameterInfoArray, MethodInfo methodInfo) throws GenerationException {
        EscapeLexer escapeLexer = new EscapeLexer(string);
        if (!this.classInfo_.isGenerateForQOC()) {
            try {
                int n2 = null != methodInfo.getParameterList() ? (methodInfo.isOnlyMethodParameterAnObjectArray() ? ParameterInfoArray.METHOD_HAS_OBJECT_ARRAY_AS_ONLY_PARAMETER : methodInfo.getParameterList().size()) : 0;
                return escapeLexer.parseSql(parameterInfoArray, n2);
            }
            catch (Exception exception) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PARSE_SQL", string), exception, 10185, null, methodInfo);
            }
        }
        String string2 = this.parseSqlForQueryOverCollection(escapeLexer, methodInfo, methodInfo.getParameterList(), this.classInfo_);
        return string2;
    }

    private String parseSqlForQueryOverCollection(EscapeLexer escapeLexer, MethodInfo methodInfo, List<TypeInfo> list, ClassInfo classInfo) throws GenerationException {
        StringBuilder stringBuilder = new StringBuilder();
        ParameterInfoArray parameterInfoArray = methodInfo.getParameterInfoArray();
        Map<Integer, BeanInformation> map = methodInfo.getInputBeanInfo();
        String string = classInfo.getPackageName();
        String string2 = string != null ? classInfo.getPackageName() + "." + classInfo.getTypeName() + "Impl$" : classInfo.getTypeName() + "Impl$";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            string4 = null;
            n2 = parameterInfoArray.getSqlParameterInfo().size();
            SqlParameterInfo sqlParameterInfo = new SqlParameterInfo();
            String string6 = escapeLexer.getUpToNextNotInQuotedStringOrRemainder(':', '?', false, true);
            if (escapeLexer.foundSearchedValue()) {
                Object object;
                Object object2;
                Object object3;
                if (string6 != null) {
                    stringBuilder.append(string6);
                }
                try {
                    string3 = escapeLexer.nextToken();
                }
                catch (DataSQLException dataSQLException) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TKN_NXT", new Object[0]), dataSQLException, 10019, null, methodInfo);
                }
                if (string3.startsWith(":")) {
                    try {
                        escapeLexer.handleHostVariable(stringBuilder, sqlParameterInfo, string3, parameterInfoArray);
                    }
                    catch (DataSQLException dataSQLException) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TKN_NXT", new Object[0]), dataSQLException, 10041, null, methodInfo);
                    }
                } else if (string3.equals("?")) {
                    n3 = n2;
                    object3 = list.get(n2);
                    if (escapeLexer.isVTIParam((TypeInfo)object3)) {
                        String string7 = "";
                        if (((TypeInfo)object3).isParameterizedType() || ((TypeInfo)object3).isArrayType()) {
                            this.checkForValidQocBaseType(n3, (TypeInfo)object3, methodInfo);
                            object2 = ((TypeInfo)object3).getBaseType();
                            String string8 = ((TypeInfo)object2).getTypeName() + "ResultSetMetaData";
                            string7 = string2 + string8;
                            if (map != null) {
                                object = map.get(n2);
                                classInfo.addQocBeanInfoMap(string8, (BeanInformation)object);
                            } else {
                                classInfo.addQocBeanInfoMap(string8, null);
                            }
                            classInfo.addToVtoMetaDataMap(string8, (TypeInfo)object2);
                        }
                        object2 = this.getVTIUsingGenericComponentClassNameTest((TypeInfo)object3, string7, methodInfo);
                        stringBuilder.append((String)object2);
                    } else {
                        stringBuilder.append(" ? ");
                    }
                    sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isNonPositionalParameterMarker__, n2, null);
                    bl2 = true;
                } else if (string3.startsWith("?")) {
                    string5 = null;
                    object3 = EscapeLexer.regExPatternBeanRef.matcher(string3);
                    boolean bl4 = false;
                    if (((Matcher)object3).matches()) {
                        bl4 = true;
                        object2 = ((Matcher)object3).group(1);
                        int n4 = ((String)object2).indexOf(".");
                        if (n4 == 0) {
                            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LEX_INV_PARM", string3), null, 10186, null, methodInfo);
                        }
                        string4 = ((String)object2).substring(0, n4);
                        if (string4 != null && string4.length() > 0 && escapeLexer.isVTIParam(list.get((n2 = Integer.parseInt(string4)) - 1))) {
                            bl4 = false;
                        }
                        if (bl4) {
                            stringBuilder.append(" ? ");
                            string5 = ((String)object2).substring(n4 + 1, ((String)object2).length());
                        }
                    }
                    if (!bl4) {
                        object3 = EscapeLexer.regExPatternVtiWithoutNum.matcher(string3);
                        if (((Matcher)object3).matches()) {
                            bl2 = true;
                        } else {
                            object3 = EscapeLexer.regExPatternVtiWithNum.matcher(string3);
                            if (((Matcher)object3).matches()) {
                                string4 = ((Matcher)object3).group(1);
                            }
                        }
                        if (string4 != null) {
                            n2 = Integer.valueOf(string4);
                            n3 = n2 - 1;
                        } else if (!string3.contains(".")) {
                            string4 = string3.substring(1);
                            n2 = Integer.valueOf(string4);
                            n3 = n2 - 1;
                        } else {
                            n3 = n2;
                        }
                        object2 = list.get(n3);
                        if (escapeLexer.isVTIParam(list.get(n3))) {
                            String string9 = "";
                            if (((TypeInfo)object2).isParameterizedType() || ((TypeInfo)object2).isArrayType()) {
                                this.checkForValidQocBaseType(n3, (TypeInfo)object2, methodInfo);
                                object = ((TypeInfo)object2).getBaseType();
                                String string10 = ((TypeInfo)object).getTypeName() + "ResultSetMetaData";
                                string9 = string2 + string10;
                                if (map != null) {
                                    BeanInformation beanInformation = map.get(n3);
                                    classInfo.addQocBeanInfoMap(string10, beanInformation);
                                } else {
                                    classInfo.addQocBeanInfoMap(string10, null);
                                }
                                classInfo.addToVtoMetaDataMap(string10, (TypeInfo)object);
                            }
                            object = this.getVTIUsingGenericComponentClassNameTest((TypeInfo)object2, string9, methodInfo);
                            stringBuilder.append((String)object);
                        } else {
                            stringBuilder.append(" ? ");
                        }
                    }
                    try {
                        if (string4 != null) {
                            bl3 = true;
                            n2 = Integer.valueOf(string4) - 1;
                        }
                        if (string5 != null) {
                            sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isBean_OR_Map__, n2, string5);
                            parameterInfoArray.setHasHostVariable(true);
                        }
                        sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isPositionalParameterMarker__, n2, null);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LEX_QMARK", new Object[0]), null, 10187, null, methodInfo);
                    }
                } else {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LEX_TOKEN", string3), null, 10188, null, methodInfo);
                }
                try {
                    parameterInfoArray.setSqlParameterInfo(sqlParameterInfo, methodInfo.getSql(), methodInfo.getParameterList().size());
                }
                catch (DataSQLException dataSQLException) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PARSE_SQL", methodInfo.getSql()), dataSQLException, 10635, null, methodInfo);
                }
                if (!bl3 || !bl2) continue;
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LEX_PARM_MIXED", new Object[0]), null, 10189, null, methodInfo);
            }
            if (string6 == null) continue;
            stringBuilder.append(string6);
        } while (escapeLexer.hasMoreTokens());
        return stringBuilder.toString();
    }

    private void checkForValidQocBaseType(int n2, TypeInfo typeInfo, MethodInfo methodInfo) throws GenerationException {
        TypeInfo typeInfo2 = typeInfo.getBaseType();
        if (typeInfo.isParameterizedType() && typeInfo2.getJavaType() == JavaType.MAP) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_UNSUP_QOC_TYPE", n2 + 1, typeInfo.getTypeName(), typeInfo2.getTypeName()), null, 10190, null, methodInfo);
        }
        if (typeInfo.isArrayType() && typeInfo2.getJavaType() == JavaType.OBJECT) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_UNSUP_QOC_ARR_TYPE", n2 + 1, typeInfo.getTypeName(), typeInfo2.getTypeName()), null, 10191, null, methodInfo);
        }
    }

    private String getVTIUsingGenericComponentClassNameTest(TypeInfo typeInfo, String string, MethodInfo methodInfo) {
        String string2 = null;
        if (typeInfo.isArrayType()) {
            string2 = "TABLE(A(?,'" + string + "', '";
            TypeInfo typeInfo2 = typeInfo.getParameterizedType().get(0);
            if (typeInfo2.isPrimitiveOrWrapper()) {
                return "TABLE(P" + typeInfo2.getTypeName().toUpperCase() + "(?))";
            }
            return string2 + typeInfo2.getPackageName() + "." + typeInfo2.getTypeName() + "'))";
        }
        if (typeInfo.getJavaType() == JavaType.LIST || typeInfo.getJavaType() == JavaType.DERIVEDLIST) {
            string2 = "TABLE(L(?,'" + string + "', '";
        }
        if (typeInfo.getJavaType() == JavaType.ITERATOR) {
            string2 = "TABLE(IR(?,'" + string + "', '";
        }
        if (typeInfo.getJavaType() == JavaType.ITERABLE || typeInfo.getJavaType() == JavaType.COLLECTION) {
            string2 = "TABLE(IE(?,'" + string + "', '";
        }
        if (string2 == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_UNSUP_COLL", typeInfo.getTypeName()), null, 10192, null, methodInfo);
        }
        TypeInfo typeInfo3 = typeInfo.getParameterizedType().get(0);
        return string2 + typeInfo3.getPackageName() + "." + typeInfo3.getTypeName() + "'))";
    }

    private SqlStatementType getSqlStatementType(String string, ParameterInfoArray parameterInfoArray, MethodInfo methodInfo) {
        EscapeLexer escapeLexer = new EscapeLexer(string);
        try {
            return escapeLexer.parseSqlAndGetSqlType();
        }
        catch (DataSQLException dataSQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PARSE_SQL", string), dataSQLException, 10156, null, methodInfo);
        }
    }

    private String getEscapedProcessedSql(String string, MethodInfo methodInfo) {
        EscapeLexer escapeLexer = new EscapeLexer(string);
        return escapeLexer.escapeUnescapedQuotes();
    }

    private void processUpdateConcurrency(MethodInfo methodInfo) throws GenerationException {
        if (SqlStatementType.isSELECTorVALUES(methodInfo.getSqlStatementType())) {
            EscapeLexer escapeLexer = new EscapeLexer(methodInfo.getProcessedSql());
            try {
                if (escapeLexer.parseSQLTextForUpdate()) {
                    methodInfo.setCursorConcurrency(1008);
                }
            }
            catch (Exception exception) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PARSE_SQL", methodInfo.getSql()), exception, 10660, null, methodInfo);
            }
        }
    }
}

