/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.configuration.ConfiguredGreenMail;
import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.pop3.Pop3Server;
import com.icegreen.greenmail.server.AbstractServer;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpServer;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.InMemoryStore;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import com.icegreen.greenmail.util.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenMail
extends ConfiguredGreenMail {
    final Logger log = LoggerFactory.getLogger(GreenMail.class);
    private Managers managers;
    private Map<String, AbstractServer> services;
    private ServerSetup[] config;

    public GreenMail() {
        this(ServerSetupTest.ALL);
    }

    public GreenMail(ServerSetup config) {
        this(new ServerSetup[]{config});
    }

    public GreenMail(ServerSetup[] config) {
        this.config = config;
        this.init();
    }

    private void init() {
        if (this.managers == null) {
            this.managers = new Managers();
        }
        if (this.services == null) {
            this.services = GreenMail.createServices(this.config, this.managers);
        }
    }

    @Override
    public synchronized void start() {
        this.init();
        Collection<AbstractServer> servers = this.services.values();
        for (AbstractServer service : servers) {
            service.startService();
        }
        for (AbstractServer service : servers) {
            try {
                service.waitTillRunning(service.getServerSetup().getServerStartupTimeout());
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException("Could not start mail service " + service, ex);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started services, performing check if all up");
        }
        for (AbstractServer service : servers) {
            if (service.isRunning()) continue;
            throw new IllegalStateException("Could not start mail server " + service + ", try to set server startup timeout > " + service.getServerSetup().getServerStartupTimeout() + " via " + ServerSetup.class.getSimpleName() + ".setServerStartupTimeout(timeoutInMs)");
        }
        this.doConfigure();
    }

    @Override
    public synchronized void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping GreenMail ...");
        }
        if (this.services != null) {
            for (Service service : this.services.values()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stopping service " + service.toString());
                }
                service.stopService();
            }
        }
        this.managers = new Managers();
        this.services = null;
    }

    @Override
    public void reset() {
        this.stop();
        this.start();
    }

    private static Map<String, AbstractServer> createServices(ServerSetup[] config, Managers mgr) {
        HashMap<String, AbstractServer> srvc = new HashMap<String, AbstractServer>();
        for (ServerSetup setup : config) {
            if (srvc.containsKey(setup.getProtocol())) {
                throw new IllegalArgumentException("Server '" + setup.getProtocol() + "' was found at least twice in the array");
            }
            String protocol = setup.getProtocol();
            if (protocol.startsWith("smtp")) {
                srvc.put(protocol, new SmtpServer(setup, mgr));
                continue;
            }
            if (protocol.startsWith("pop3")) {
                srvc.put(protocol, new Pop3Server(setup, mgr));
                continue;
            }
            if (!protocol.startsWith("imap")) continue;
            srvc.put(protocol, new ImapServer(setup, mgr));
        }
        return srvc;
    }

    @Override
    public SmtpServer getSmtp() {
        return (SmtpServer)this.services.get("smtp");
    }

    @Override
    public ImapServer getImap() {
        return (ImapServer)this.services.get("imap");
    }

    @Override
    public Pop3Server getPop3() {
        return (Pop3Server)this.services.get("pop3");
    }

    @Override
    public SmtpServer getSmtps() {
        return (SmtpServer)this.services.get("smtps");
    }

    @Override
    public ImapServer getImaps() {
        return (ImapServer)this.services.get("imaps");
    }

    @Override
    public Pop3Server getPop3s() {
        return (Pop3Server)this.services.get("pop3s");
    }

    @Override
    public Managers getManagers() {
        return this.managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForIncomingEmail(long timeout, int emailCount) {
        SmtpManager.WaitObject o = this.managers.getSmtpManager().createAndAddNewWaitObject(emailCount);
        if (null == o) {
            return true;
        }
        SmtpManager.WaitObject waitObject = o;
        synchronized (waitObject) {
            long t0 = System.currentTimeMillis();
            while (!o.isArrived()) {
                try {
                    o.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread was interrupted while waiting", e);
                }
                if (System.currentTimeMillis() - t0 <= timeout) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean waitForIncomingEmail(int emailCount) {
        return this.waitForIncomingEmail(5000L, emailCount);
    }

    @Override
    public MimeMessage[] getReceivedMessages() {
        List<StoredMessage> msgs = this.managers.getImapHostManager().getAllMessages();
        MimeMessage[] ret = new MimeMessage[msgs.size()];
        for (int i = 0; i < msgs.size(); ++i) {
            StoredMessage storedMessage = msgs.get(i);
            ret[i] = storedMessage.getMimeMessage();
        }
        return ret;
    }

    @Override
    @Deprecated
    public MimeMessage[] getReceviedMessagesForDomain(String domain) {
        return this.getReceivedMessagesForDomain(domain);
    }

    @Override
    public MimeMessage[] getReceivedMessagesForDomain(String domain) {
        List<StoredMessage> msgs = this.managers.getImapHostManager().getAllMessages();
        ArrayList<MimeMessage> ret = new ArrayList<MimeMessage>();
        try {
            for (StoredMessage msg : msgs) {
                String tos = GreenMailUtil.getAddressList(msg.getMimeMessage().getAllRecipients());
                if (!tos.toLowerCase().contains(domain)) continue;
                ret.add(msg.getMimeMessage());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return ret.toArray(new MimeMessage[ret.size()]);
    }

    @Override
    public GreenMailUser setUser(String login, String password) {
        return this.setUser(login, login, password);
    }

    @Override
    public GreenMailUser setUser(String email, String login, String password) {
        GreenMailUser user = this.managers.getUserManager().getUser(login);
        if (null == user) {
            try {
                user = this.managers.getUserManager().createUser(email, login, password);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
        } else {
            user.setPassword(password);
        }
        return user;
    }

    @Override
    public void setQuotaSupported(boolean isEnabled) {
        this.managers.getImapHostManager().getStore().setQuotaSupported(isEnabled);
    }

    @Override
    public void setUsers(Properties users) {
        for (Object o : users.keySet()) {
            String email = (String)o;
            String password = users.getProperty(email);
            this.setUser(email, email, password);
        }
    }

    @Override
    public GreenMail withConfiguration(GreenMailConfiguration config) {
        super.withConfiguration(config);
        return this;
    }

    @Override
    public void purgeEmailFromAllMailboxes() throws FolderException {
        ImapHostManager imaphost = this.getManagers().getImapHostManager();
        InMemoryStore store = (InMemoryStore)imaphost.getStore();
        Collection<MailFolder> mailboxes = store.listMailboxes("*");
        for (MailFolder folder : mailboxes) {
            folder.deleteAllMessages();
        }
    }

    @Deprecated
    public GreenMailUtil util() {
        return GreenMailUtil.instance();
    }
}

