/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.Duration;
import com.influxdb.client.domain.Expression;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents the elapsed time between two instants as an int64 nanosecond count with syntax of golang's time.Duration")
public class DurationLiteral
extends Expression {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<Duration> values = new ArrayList<Duration>();

    public DurationLiteral type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of AST node")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DurationLiteral values(List<Duration> values) {
        this.values = values;
        return this;
    }

    public DurationLiteral addValuesItem(Duration valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Duration>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(value="Duration values")
    public List<Duration> getValues() {
        return this.values;
    }

    public void setValues(List<Duration> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationLiteral durationLiteral = (DurationLiteral)o;
        return Objects.equals(this.type, durationLiteral.type) && Objects.equals(this.values, durationLiteral.values) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.values, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DurationLiteral {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

