/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.mac;

import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.AbstractMacIntegrityProtector;
import com.itextpdf.kernel.mac.MacPdfObject;
import com.itextpdf.kernel.mac.MacProperties;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEvent;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEventHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

class StandaloneMacIntegrityProtector
extends AbstractMacIntegrityProtector {
    private MacPdfObject macPdfObject;

    StandaloneMacIntegrityProtector(PdfDocument document, MacProperties macProperties) {
        super(document, macProperties);
    }

    StandaloneMacIntegrityProtector(PdfDocument document, PdfDictionary authDictionary) {
        super(document, authDictionary);
    }

    void prepareDocument() {
        this.document.addEventHandler("StartDocumentClosing", new StandaloneMacPdfObjectAdder());
        this.document.addEventHandler("StartWriterClosing", new StandaloneMacContainerEmbedder());
    }

    private void embedMacContainerInTrailer() throws IOException {
        byte[] documentBytes = this.getDocumentByteArrayOutputStream().toByteArray();
        long[] byteRange = this.macPdfObject.computeByteRange(documentBytes.length);
        long byteRangePosition = this.macPdfObject.getByteRangePosition();
        ByteArrayOutputStream localBaos = new ByteArrayOutputStream();
        PdfOutputStream os = new PdfOutputStream(localBaos);
        os.write(91);
        for (long l : byteRange) {
            ((PdfOutputStream)((Object)os.writeLong(l))).write(32);
        }
        os.write(93);
        System.arraycopy(localBaos.toByteArray(), 0, documentBytes, (int)byteRangePosition, localBaos.size());
        byte[] mac = this.createDocumentDigestAndMacContainer(documentBytes, byteRange);
        PdfString macString = new PdfString(mac).setHexWriting(true);
        localBaos.reset();
        os.write((PdfObject)macString);
        System.arraycopy(localBaos.toByteArray(), 0, documentBytes, (int)byteRange[1], localBaos.size());
        this.getDocumentByteArrayOutputStream().reset();
        this.document.getWriter().getOutputStream().write(documentBytes, 0, documentBytes.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] createDocumentDigestAndMacContainer(byte[] documentBytes, long[] byteRange) throws IOException {
        IRandomAccessSource ras = new RandomAccessSourceFactory().createSource(documentBytes);
        try (RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(ras, byteRange));){
            byte[] dataDigest = this.digestBytes((InputStream)rg);
            byte[] byArray = this.createMacContainer(dataDigest, StandaloneMacIntegrityProtector.generateRandomBytes(32), null).getEncoded();
            return byArray;
        }
        catch (GeneralSecurityException e) {
            throw new PdfException("Exception occurred during MAC container generation.", e);
        }
    }

    private int getContainerSizeEstimate() {
        try {
            return this.createMacContainer(this.digestBytes(new byte[0]), StandaloneMacIntegrityProtector.generateRandomBytes(32), null).getEncoded().length * 2 + 2;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new PdfException("Exception occurred during MAC container generation.", e);
        }
    }

    private ByteArrayOutputStream getDocumentByteArrayOutputStream() {
        return (ByteArrayOutputStream)this.document.getWriter().getOutputStream();
    }

    private final class StandaloneMacContainerEmbedder
    extends AbstractPdfDocumentEventHandler {
        private StandaloneMacContainerEmbedder() {
        }

        @Override
        public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
            try {
                StandaloneMacIntegrityProtector.this.embedMacContainerInTrailer();
            }
            catch (IOException e) {
                throw new PdfException("IOException occurred while trying to embed MAC container into document output stream.", e);
            }
        }
    }

    private final class StandaloneMacPdfObjectAdder
    extends AbstractPdfDocumentEventHandler {
        private StandaloneMacPdfObjectAdder() {
        }

        @Override
        public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
            StandaloneMacIntegrityProtector.this.macPdfObject = new MacPdfObject(StandaloneMacIntegrityProtector.this.getContainerSizeEstimate());
            StandaloneMacIntegrityProtector.this.document.getTrailer().put(PdfName.AuthCode, (PdfObject)StandaloneMacIntegrityProtector.this.macPdfObject.getPdfObject());
        }
    }
}

