/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.annotationsflattening;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.utils.annotationsflattening.DefaultAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.HighLightTextMarkupAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.IAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.NotSupportedFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.RemoveWithoutDrawingFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.SquigglyTextMarkupAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.StrikeOutTextMarkupAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.UnderlineTextMarkupAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.WarnFormfieldFlattener;
import java.util.HashMap;
import java.util.function.Supplier;

public class PdfAnnotationFlattenFactory {
    private static final HashMap<PdfName, Supplier<IAnnotationFlattener>> map;
    private static final PdfName UNKNOWN;

    public IAnnotationFlattener getAnnotationFlattenWorker(PdfName name) {
        Supplier<IAnnotationFlattener> worker = map.get(name);
        if (worker == null) {
            worker = map.get(UNKNOWN);
        }
        return worker.get();
    }

    static {
        UNKNOWN = new PdfName("Unknown");
        map = new HashMap();
        map.put(PdfName.Link, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Popup, () -> new RemoveWithoutDrawingFlattener());
        map.put(PdfName.Widget, () -> new WarnFormfieldFlattener());
        map.put(PdfName.Screen, () -> new DefaultAnnotationFlattener());
        map.put(PdfName._3D, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Highlight, () -> new HighLightTextMarkupAnnotationFlattener());
        map.put(PdfName.Underline, () -> new UnderlineTextMarkupAnnotationFlattener());
        map.put(PdfName.Squiggly, () -> new SquigglyTextMarkupAnnotationFlattener());
        map.put(PdfName.StrikeOut, () -> new StrikeOutTextMarkupAnnotationFlattener());
        map.put(PdfName.Caret, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Text, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Sound, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Stamp, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.FileAttachment, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Ink, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.PrinterMark, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.TrapNet, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.FreeText, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Square, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Circle, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Line, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Polygon, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.PolyLine, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Redact, () -> new DefaultAnnotationFlattener());
        map.put(PdfName.Watermark, () -> new DefaultAnnotationFlattener());
        map.put(UNKNOWN, () -> new NotSupportedFlattener());
    }
}

