/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.properties.grid.AutoValue;
import com.itextpdf.layout.properties.grid.GridValue;
import com.itextpdf.layout.renderer.Grid;
import com.itextpdf.layout.renderer.GridCell;
import com.itextpdf.layout.renderer.GridTrackSizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class GridSizer {
    private final Grid grid;
    private final List<GridValue> templateColumns;
    private final List<GridValue> templateRows;
    private final GridValue columnAutoWidth;
    private final GridValue rowAutoHeight;
    private final float columnGap;
    private final float rowGap;
    private final Rectangle actualBBox;
    private float containerHeight;

    GridSizer(Grid grid, List<GridValue> templateColumns, List<GridValue> templateRows, GridValue columnAutoWidth, GridValue rowAutoHeight, float columnGap, float rowGap, Rectangle actualBBox) {
        this.grid = grid;
        this.templateColumns = templateColumns;
        this.templateRows = templateRows;
        this.columnAutoWidth = columnAutoWidth;
        this.rowAutoHeight = rowAutoHeight;
        this.columnGap = columnGap;
        this.rowGap = rowGap;
        this.actualBBox = actualBBox;
    }

    public void sizeGrid() {
        this.resolveGridColumns();
        this.resolveGridRows();
    }

    public float getContainerHeight() {
        return this.containerHeight;
    }

    private void resolveGridRows() {
        ArrayList<GridValue> rowsValues = new ArrayList<GridValue>();
        for (int i = 0; i < this.grid.getNumberOfRows(); ++i) {
            if (this.templateRows != null && i - this.grid.getRowOffset() < this.templateRows.size() && i - this.grid.getRowOffset() >= 0) {
                rowsValues.add(this.templateRows.get(i - this.grid.getRowOffset()));
                continue;
            }
            if (this.rowAutoHeight != null) {
                rowsValues.add(this.rowAutoHeight);
                continue;
            }
            rowsValues.add(AutoValue.VALUE);
        }
        GridTrackSizer gridTrackSizer = new GridTrackSizer(this.grid, rowsValues, this.rowGap, this.actualBBox.getHeight(), Grid.GridOrder.ROW);
        GridTrackSizer.TrackSizingResult result = gridTrackSizer.sizeTracks();
        List<Float> rows = result.getTrackSizesAndExpandPercents(rowsValues);
        for (GridCell cell : this.grid.getUniqueGridCells(Grid.GridOrder.ROW)) {
            float y = 0.0f;
            for (int currentRow = 0; currentRow < cell.getRowStart(); ++currentRow) {
                y += rows.get(currentRow).floatValue();
                y += this.rowGap;
            }
            cell.getLayoutArea().setY(y);
            float cellHeight = 0.0f;
            float[] rowSizes = new float[cell.getRowEnd() - cell.getRowStart()];
            int rowSizesIdx = 0;
            for (int i = cell.getRowStart(); i < cell.getRowEnd(); ++i) {
                rowSizes[rowSizesIdx] = rows.get(i).floatValue();
                if (rowSizesIdx != 0) {
                    int n = rowSizesIdx;
                    rowSizes[n] = rowSizes[n] + this.rowGap;
                }
                ++rowSizesIdx;
                cellHeight += rows.get(i).floatValue();
            }
            cell.setRowSizes(rowSizes);
            cell.getLayoutArea().setHeight(cellHeight += (float)(cell.getGridHeight() - 1) * this.rowGap);
        }
        this.containerHeight = this.calculateGridOccupiedHeight(result.getTrackSizes());
    }

    private float calculateGridOccupiedHeight(List<Float> originalSizes) {
        float minHeight = 0.0f;
        for (int i = 0; i < (this.templateRows == null ? 0 : Math.min(this.templateRows.size(), originalSizes.size())); ++i) {
            minHeight += originalSizes.get(i).floatValue();
        }
        float maxHeight = this.sum(originalSizes);
        minHeight += (float)(this.grid.getNumberOfRows() - 1) * this.rowGap;
        maxHeight += (float)(this.grid.getNumberOfRows() - 1) * this.rowGap;
        float occupiedHeight = 0.0f;
        Collection<GridCell> cells = this.grid.getUniqueGridCells(Grid.GridOrder.ROW);
        for (GridCell cell : cells) {
            occupiedHeight = Math.max(occupiedHeight, cell.getLayoutArea().getTop());
        }
        return Math.max(Math.min(maxHeight, occupiedHeight), minHeight);
    }

    private float sum(List<Float> trackSizes) {
        float sum = 0.0f;
        for (Float size : trackSizes) {
            sum += size.floatValue();
        }
        return sum;
    }

    private void resolveGridColumns() {
        ArrayList<GridValue> colsValues = new ArrayList<GridValue>();
        for (int i = 0; i < this.grid.getNumberOfColumns(); ++i) {
            if (this.templateColumns != null && i - this.grid.getColumnOffset() < this.templateColumns.size() && i - this.grid.getColumnOffset() >= 0) {
                colsValues.add(this.templateColumns.get(i - this.grid.getColumnOffset()));
                continue;
            }
            if (this.columnAutoWidth != null) {
                colsValues.add(this.columnAutoWidth);
                continue;
            }
            colsValues.add(AutoValue.VALUE);
        }
        GridTrackSizer gridTrackSizer = new GridTrackSizer(this.grid, colsValues, this.columnGap, this.actualBBox.getWidth(), Grid.GridOrder.COLUMN);
        List<Float> columns = gridTrackSizer.sizeTracks().getTrackSizesAndExpandPercents(colsValues);
        for (GridCell cell : this.grid.getUniqueGridCells(Grid.GridOrder.COLUMN)) {
            float x = 0.0f;
            for (int currentColumn = 0; currentColumn < cell.getColumnStart(); ++currentColumn) {
                x += columns.get(currentColumn).floatValue();
                x += this.columnGap;
            }
            cell.getLayoutArea().setX(x);
            float cellWidth = 0.0f;
            for (int i = cell.getColumnStart(); i < cell.getColumnEnd(); ++i) {
                cellWidth += columns.get(i).floatValue();
            }
            cell.getLayoutArea().setWidth(cellWidth += (float)(cell.getGridWidth() - 1) * this.columnGap);
        }
    }
}

