/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfUAConformance;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.validation.IValidationChecker;
import com.itextpdf.kernel.validation.ValidationContainer;
import com.itextpdf.pdfua.PdfUAConfig;
import com.itextpdf.pdfua.PdfUAPageFactory;
import com.itextpdf.pdfua.checkers.PdfUA1Checker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUADocument
extends PdfDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfUADocument.class);

    public PdfUADocument(PdfWriter writer, PdfUAConfig config) {
        this(writer, new DocumentProperties(), config);
    }

    public PdfUADocument(PdfWriter writer, DocumentProperties properties, PdfUAConfig config) {
        super(PdfUADocument.configureWriterProperties(writer), properties);
        this.pdfConformance = new PdfConformance(config.getConformance());
        this.setupUAConfiguration(config);
        ValidationContainer validationContainer = new ValidationContainer();
        PdfUA1Checker checker = new PdfUA1Checker(this);
        validationContainer.addChecker((IValidationChecker)checker);
        this.getDiContainer().register(ValidationContainer.class, (Object)validationContainer);
        this.pdfPageFactory = new PdfUAPageFactory(checker);
    }

    public PdfUADocument(PdfReader reader, PdfWriter writer, PdfUAConfig config) {
        this(reader, writer, new StampingProperties(), config);
    }

    public PdfUADocument(PdfReader reader, PdfWriter writer, StampingProperties properties, PdfUAConfig config) {
        super(reader, writer, properties);
        if (!this.getConformance().isPdfUA()) {
            LOGGER.warn("PDF to PDF/UA conversion is not supported.");
        }
        this.setupUAConfiguration(config);
        ValidationContainer validationContainer = new ValidationContainer();
        PdfUA1Checker checker = new PdfUA1Checker(this);
        validationContainer.addChecker((IValidationChecker)checker);
        this.getDiContainer().register(ValidationContainer.class, (Object)validationContainer);
        this.pdfPageFactory = new PdfUAPageFactory(checker);
    }

    private static PdfWriter configureWriterProperties(PdfWriter writer) {
        writer.getProperties().addPdfUaXmpMetadata(PdfUAConformance.PDF_UA_1);
        if (writer.getPdfVersion() != null && !writer.getPdfVersion().equals((Object)PdfVersion.PDF_1_7)) {
            LoggerFactory.getLogger(PdfUADocument.class).warn(MessageFormatUtil.format((String)"Pdf version from writer properties isn't compatible with specified PDF/UA conformance, it was overridden to {0} version.", (Object[])new Object[]{PdfVersion.PDF_1_7}));
            writer.getProperties().setPdfVersion(PdfVersion.PDF_1_7);
        }
        return writer;
    }

    private void setupUAConfiguration(PdfUAConfig config) {
        this.setTagged();
        this.getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
        this.getCatalog().setLang(new PdfString(config.getLanguage()));
        PdfDocumentInfo info = this.getDocumentInfo();
        info.setTitle(config.getTitle());
    }
}

