/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.cms;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;

public class AlgorithmIdentifier {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final String algorithm;
    private final IASN1Primitive parameters;

    public AlgorithmIdentifier(String algorithmId) {
        this.algorithm = algorithmId;
        this.parameters = null;
    }

    public AlgorithmIdentifier(String algorithmId, IASN1Primitive parameters) {
        this.algorithm = algorithmId;
        this.parameters = parameters;
    }

    AlgorithmIdentifier(IASN1Encodable asnStruct) {
        IASN1Sequence algIdentifier = BC_FACTORY.createASN1Sequence(asnStruct);
        IASN1ObjectIdentifier algOid = BC_FACTORY.createASN1ObjectIdentifier(algIdentifier.getObjectAt(0));
        this.algorithm = algOid.getId();
        this.parameters = algIdentifier.size() > 1 ? BC_FACTORY.createASN1Primitive(algIdentifier.getObjectAt(1)) : null;
    }

    public String getAlgorithmOid() {
        return this.algorithm;
    }

    public IASN1Primitive getParameters() {
        return this.parameters;
    }

    IASN1Sequence getAsASN1Sequence() {
        IASN1EncodableVector algorithmV = BC_FACTORY.createASN1EncodableVector();
        algorithmV.add((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier(this.algorithm));
        if (this.parameters != null) {
            algorithmV.add(this.parameters);
        }
        return BC_FACTORY.createDERSequence(algorithmV);
    }
}

