/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipPathSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    private AbstractSvgNodeRenderer clippedRenderer;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        ClipPathSvgNodeRenderer copy = new ClipPathSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }

    @Override
    void preDraw(SvgDrawContext context) {
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.clippedRenderer == null) {
            return;
        }
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        for (ISvgNodeRenderer child : this.getChildren()) {
            if (child instanceof AbstractSvgNodeRenderer && ((AbstractSvgNodeRenderer)child).isHidden()) continue;
            currentCanvas.saveState();
            child.setParent(this);
            child.draw(context);
            if (!(child instanceof TextSvgBranchRenderer)) {
                this.drawClippedRenderer(context);
            }
            if (!context.getClippingElementTransform().isIdentity()) {
                context.resetClippingElementTransform();
            }
            currentCanvas.restoreState();
        }
    }

    public void drawClippedRenderer(SvgDrawContext context) {
        if (!context.getClippingElementTransform().isIdentity()) {
            try {
                context.getCurrentCanvas().concatMatrix(context.getClippingElementTransform().createInverse());
            }
            catch (NoninvertibleTransformException e) {
                Logger logger = LoggerFactory.getLogger(ClipPathSvgNodeRenderer.class);
                logger.warn("Non-invertible transformation matrix was used in a clipping path context. Clipped elements may show undefined behavior.");
            }
        }
        this.clippedRenderer.preDraw(context);
        this.clippedRenderer.doDraw(context);
        this.clippedRenderer.postDraw(context);
    }

    public void setClippedRenderer(AbstractSvgNodeRenderer clippedRenderer) {
        this.clippedRenderer = clippedRenderer;
    }

    @Override
    protected boolean isHidden() {
        return "none".equals(this.attributesAndStyles.get("display")) && !"hidden".equals(this.attributesAndStyles.get("visibility"));
    }
}

