/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.logsender;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILogSender
extends IInterface {
    public static final String DESCRIPTOR = "com.itsaky.androidide.logsender.ILogSender";

    public void ping() throws RemoteException;

    public void startReader(int var1) throws RemoteException;

    public int getPid() throws RemoteException;

    public String getPackageName() throws RemoteException;

    public String getId() throws RemoteException;

    public void onDisconnect() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILogSender {
        static final int TRANSACTION_ping = 1;
        static final int TRANSACTION_startReader = 2;
        static final int TRANSACTION_getPid = 3;
        static final int TRANSACTION_getPackageName = 4;
        static final int TRANSACTION_getId = 5;
        static final int TRANSACTION_onDisconnect = 6;

        public Stub() {
            this.attachInterface(this, ILogSender.DESCRIPTOR);
        }

        public static ILogSender asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILogSender.DESCRIPTOR);
            if (iin != null && iin instanceof ILogSender) {
                return (ILogSender)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILogSender.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.ping();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.startReader(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _result = this.getPid();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    String _result = this.getPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    String _result = this.getId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 6: {
                    this.onDisconnect();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ILogSender {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILogSender.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ping() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogSender.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startReader(int port) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogSender.DESCRIPTOR);
                    _data.writeInt(port);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPid() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogSender.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogSender.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogSender.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogSender.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILogSender {
        @Override
        public void ping() throws RemoteException {
        }

        @Override
        public void startReader(int port) throws RemoteException {
        }

        @Override
        public int getPid() throws RemoteException {
            return 0;
        }

        @Override
        public String getPackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getId() throws RemoteException {
            return null;
        }

        @Override
        public void onDisconnect() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

