/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.logsender;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.itsaky.androidide.logsender.ILogReceiver;
import com.itsaky.androidide.logsender.ILogSender;
import com.itsaky.androidide.logsender.LogSenderService;
import com.itsaky.androidide.logsender.utils.LogReader;
import com.itsaky.androidide.logsender.utils.Logger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LogSender
extends ILogSender.Stub
implements ServiceConnection {
    private final AtomicBoolean isBinding = new AtomicBoolean(false);
    private final AtomicBoolean isConnected = new AtomicBoolean(false);
    private final String senderId = UUID.randomUUID().toString();
    private Context context;
    private LogReader reader;
    private ILogReceiver receiver;
    private String packageName;
    public static final String SERVICE_ACTION = "com.itsaky.androidide.LOG_SERVICE_ACTION";
    public static final String PACKAGE_UNKNOWN = "<unknown-package-name>";
    public static final String PACKAGE_ANDROIDIDE = "com.itsaky.androidide";

    LogSender() {
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.receiver = ILogReceiver.Stub.asInterface(service);
        if (this.receiver == null) {
            throw new IllegalStateException("Failed to get log receiver instance");
        }
        try {
            this.receiver.connect(this);
            Logger.info("Connecting to log receiver");
            this.isConnected.set(true);
        }
        catch (RemoteException e) {
            Logger.error(new Object[]{"Failed to connect to log receiver", e});
            throw new RuntimeException(e);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.tryDisconnect(true);
        if (this.context != null) {
            this.tryUnbind(this.context);
            this.context = null;
        }
    }

    @Override
    public void ping() {
        Log.d((String)"LogSender", (String)"ping: Received a ping request");
    }

    @Override
    public void startReader(int port) {
        if (this.reader != null && this.reader.isAlive()) {
            Logger.warn("LogReader has already been started");
            return;
        }
        this.reader = new LogReader(this.getId(), this.getPackageName(), port);
        this.reader.start();
    }

    @Override
    public int getPid() {
        return Process.myPid();
    }

    @Override
    public String getPackageName() {
        if (this.packageName == null) {
            return PACKAGE_UNKNOWN;
        }
        return this.packageName;
    }

    @Override
    public String getId() {
        return this.senderId;
    }

    @Override
    public void onDisconnect() {
        this.tryDisconnect(false);
        this.tryUnbind(this.context);
        try {
            this.context.stopService(new Intent(this.context, LogSenderService.class));
        }
        catch (Exception err) {
            Logger.error("Failed to stop LogSenderService", err);
        }
        this.context = null;
    }

    boolean isBinding() {
        return this.isBinding.get();
    }

    boolean isConnected() {
        return this.isConnected.get();
    }

    boolean bind(Context context) {
        if (this.isConnected()) {
            Logger.warn("LogSender is already installed");
            return true;
        }
        if (this.isBinding()) {
            Logger.warn("LogSender is already being installed");
            return true;
        }
        this.packageName = context.getPackageName();
        if (PACKAGE_ANDROIDIDE.equals(this.packageName)) {
            return false;
        }
        this.context = context;
        Intent intent = new Intent(SERVICE_ACTION);
        intent.setPackage(PACKAGE_ANDROIDIDE);
        this.isBinding.set(context.bindService(intent, (ServiceConnection)this, 65));
        if (this.isBinding()) {
            Logger.info("Binding to log receiver");
        } else {
            Logger.error("Failed to bind to log receiver");
        }
        return this.isBinding();
    }

    void destroy(Context context) {
        this.tryDisconnect(true);
        this.tryUnbind(context);
        this.context = null;
    }

    private void tryDisconnect(boolean notifyRecevier) {
        Logger.info("Disconnecting from log receiver...");
        if (this.reader != null) {
            this.reader.cancel();
        }
        if (notifyRecevier && this.isReceiverAlive(this.receiver)) {
            try {
                this.receiver.disconnect(this.getPackageName(), this.getId());
            }
            catch (Exception err) {
                Logger.error("Failed to disconnect from log receiver service", err);
            }
        }
        this.receiver = null;
        this.reader = null;
        this.isBinding.set(false);
        this.isConnected.set(false);
    }

    private void tryUnbind(Context context) {
        try {
            context.unbindService((ServiceConnection)this);
        }
        catch (Exception err) {
            Logger.error("Failed to unbind from the the log receiver service", err);
        }
    }

    private boolean isReceiverAlive(ILogReceiver receiver) {
        if (receiver == null) {
            return false;
        }
        try {
            receiver.ping();
            return true;
        }
        catch (RemoteException err) {
            return false;
        }
    }
}

