/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.mapper.factory.DefaultGsonObjectMapperFactory;
import com.jayway.restassured.mapper.factory.DefaultJAXBObjectMapperFactory;
import com.jayway.restassured.mapper.factory.DefaultJackson1ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.DefaultJackson2ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.GsonObjectMapperFactory;
import com.jayway.restassured.mapper.factory.JAXBObjectMapperFactory;
import com.jayway.restassured.mapper.factory.Jackson1ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.Jackson2ObjectMapperFactory;
import org.apache.commons.lang3.Validate;

public class ObjectMapperConfig {
    private final ObjectMapper defaultObjectMapper;
    private final ObjectMapperType defaultObjectMapperType;
    private final GsonObjectMapperFactory gsonObjectMapperFactory;
    private final Jackson1ObjectMapperFactory jackson1ObjectMapperFactory;
    private final Jackson2ObjectMapperFactory jackson2ObjectMapperFactory;
    private final JAXBObjectMapperFactory jaxbObjectMapperFactory;

    public ObjectMapperConfig() {
        this.defaultObjectMapper = null;
        this.defaultObjectMapperType = null;
        this.gsonObjectMapperFactory = new DefaultGsonObjectMapperFactory();
        this.jackson1ObjectMapperFactory = new DefaultJackson1ObjectMapperFactory();
        this.jackson2ObjectMapperFactory = new DefaultJackson2ObjectMapperFactory();
        this.jaxbObjectMapperFactory = new DefaultJAXBObjectMapperFactory();
    }

    public ObjectMapperConfig(ObjectMapperType defaultObjectMapperType) {
        this(null, defaultObjectMapperType, (GsonObjectMapperFactory)new DefaultGsonObjectMapperFactory(), (Jackson1ObjectMapperFactory)new DefaultJackson1ObjectMapperFactory(), (Jackson2ObjectMapperFactory)new DefaultJackson2ObjectMapperFactory(), (JAXBObjectMapperFactory)new DefaultJAXBObjectMapperFactory());
    }

    public ObjectMapperConfig(ObjectMapper defaultObjectMapper) {
        this(defaultObjectMapper, null, (GsonObjectMapperFactory)new DefaultGsonObjectMapperFactory(), (Jackson1ObjectMapperFactory)new DefaultJackson1ObjectMapperFactory(), (Jackson2ObjectMapperFactory)new DefaultJackson2ObjectMapperFactory(), (JAXBObjectMapperFactory)new DefaultJAXBObjectMapperFactory());
    }

    private ObjectMapperConfig(ObjectMapper defaultObjectMapper, ObjectMapperType defaultObjectMapperType, GsonObjectMapperFactory gsonObjectMapperFactory, Jackson1ObjectMapperFactory jackson1ObjectMapperFactory, Jackson2ObjectMapperFactory jackson2ObjectMapperFactory, JAXBObjectMapperFactory jaxbObjectMapperFactory) {
        Validate.notNull((Object)gsonObjectMapperFactory, (String)(GsonObjectMapperFactory.class.getSimpleName() + " cannot be null"), (Object[])new Object[0]);
        Validate.notNull((Object)jackson1ObjectMapperFactory, (String)(Jackson1ObjectMapperFactory.class.getSimpleName() + " cannot be null"), (Object[])new Object[0]);
        Validate.notNull((Object)jackson2ObjectMapperFactory, (String)(Jackson2ObjectMapperFactory.class.getSimpleName() + " cannot be null"), (Object[])new Object[0]);
        Validate.notNull((Object)jaxbObjectMapperFactory, (String)(JAXBObjectMapperFactory.class.getSimpleName() + " cannot be null"), (Object[])new Object[0]);
        this.defaultObjectMapperType = defaultObjectMapperType;
        this.defaultObjectMapper = defaultObjectMapper;
        this.gsonObjectMapperFactory = gsonObjectMapperFactory;
        this.jackson1ObjectMapperFactory = jackson1ObjectMapperFactory;
        this.jackson2ObjectMapperFactory = jackson2ObjectMapperFactory;
        this.jaxbObjectMapperFactory = jaxbObjectMapperFactory;
    }

    public ObjectMapperType defaultObjectMapperType() {
        return this.defaultObjectMapperType;
    }

    public boolean hasDefaultObjectMapperType() {
        return this.defaultObjectMapperType != null;
    }

    public ObjectMapperConfig defaultObjectMapperType(ObjectMapperType defaultObjectMapperType) {
        return new ObjectMapperConfig(defaultObjectMapperType);
    }

    public ObjectMapper defaultObjectMapper() {
        return this.defaultObjectMapper;
    }

    public boolean hasDefaultObjectMapper() {
        return this.defaultObjectMapper != null;
    }

    public ObjectMapperConfig defaultObjectMapper(ObjectMapper defaultObjectMapper) {
        return new ObjectMapperConfig(defaultObjectMapper);
    }

    public GsonObjectMapperFactory gsonObjectMapperFactory() {
        return this.gsonObjectMapperFactory;
    }

    public ObjectMapperConfig gsonObjectMapperFactory(GsonObjectMapperFactory gsonObjectMapperFactory) {
        return new ObjectMapperConfig(this.defaultObjectMapper, this.defaultObjectMapperType, gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.jaxbObjectMapperFactory);
    }

    public Jackson1ObjectMapperFactory jackson1ObjectMapperFactory() {
        return this.jackson1ObjectMapperFactory;
    }

    public ObjectMapperConfig jackson1ObjectMapperFactory(Jackson1ObjectMapperFactory jackson1ObjectMapperFactory) {
        return new ObjectMapperConfig(this.defaultObjectMapper, this.defaultObjectMapperType, this.gsonObjectMapperFactory, jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.jaxbObjectMapperFactory);
    }

    public Jackson2ObjectMapperFactory jackson2ObjectMapperFactory() {
        return this.jackson2ObjectMapperFactory;
    }

    public ObjectMapperConfig jackson2ObjectMapperFactory(Jackson2ObjectMapperFactory jackson2ObjectMapperFactory) {
        return new ObjectMapperConfig(this.defaultObjectMapper, this.defaultObjectMapperType, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, jackson2ObjectMapperFactory, this.jaxbObjectMapperFactory);
    }

    public JAXBObjectMapperFactory jaxbObjectMapperFactory() {
        return this.jaxbObjectMapperFactory;
    }

    public ObjectMapperConfig jaxbObjectMapperFactory(JAXBObjectMapperFactory jaxbObjectMapperFactory) {
        return new ObjectMapperConfig(this.defaultObjectMapper, this.defaultObjectMapperType, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, jaxbObjectMapperFactory);
    }

    public static ObjectMapperConfig objectMapperConfig() {
        return new ObjectMapperConfig();
    }

    public ObjectMapperConfig and() {
        return this;
    }
}

