/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SessionConfig {
    public static final String DEFAULT_SESSION_ID_NAME = "JSESSIONID";
    private final String sessionIdName;
    private final String sessionIdValue;

    public SessionConfig() {
        this(DEFAULT_SESSION_ID_NAME, null);
    }

    public SessionConfig(String sessionIdValue) {
        this(DEFAULT_SESSION_ID_NAME, sessionIdValue);
    }

    public SessionConfig(String sessionIdName, String sessionIdValue) {
        Validate.notEmpty((CharSequence)sessionIdName, (String)"Session id name cannot be empty.", (Object[])new Object[0]);
        this.sessionIdName = sessionIdName;
        this.sessionIdValue = sessionIdValue;
    }

    public boolean isSessionIdValueDefined() {
        return !StringUtils.isBlank((CharSequence)this.sessionIdValue);
    }

    public SessionConfig sessionIdValue(String defaultSessionId) {
        return new SessionConfig(this.sessionIdName, defaultSessionId);
    }

    public SessionConfig sessionIdName(String sessionIdName) {
        return new SessionConfig(sessionIdName, this.sessionIdValue);
    }

    public String sessionIdName() {
        return this.sessionIdName;
    }

    public String sessionIdValue() {
        return this.sessionIdValue;
    }

    public static SessionConfig sessionConfig() {
        return new SessionConfig();
    }

    public SessionConfig and() {
        return this;
    }
}

