/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterActivity;
import com.karumi.dexter.DexterException;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionListenerThreadDecorator;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionRationaleToken;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.Thread;
import com.karumi.dexter.listener.DexterError;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.BaseMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

final class DexterInstance {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private static final MultiplePermissionsListener EMPTY_LISTENER = new BaseMultiplePermissionsListener();
    private WeakReference<Context> context;
    private final AndroidPermissionService androidPermissionService;
    private final IntentProvider intentProvider;
    private final Collection<String> pendingPermissions;
    private final MultiplePermissionsReport multiplePermissionsReport;
    private final AtomicBoolean isRequestingPermission;
    private final AtomicBoolean rationaleAccepted;
    private final AtomicBoolean isShowingNativeDialog;
    private final Object pendingPermissionsMutex;
    private Activity activity;
    private MultiplePermissionsListener listener;

    DexterInstance(Context context, AndroidPermissionService androidPermissionService, IntentProvider intentProvider) {
        DexterInstance dexterInstance = this;
        this.pendingPermissionsMutex = new Object();
        this.listener = EMPTY_LISTENER;
        this.androidPermissionService = androidPermissionService;
        dexterInstance.intentProvider = intentProvider;
        dexterInstance.pendingPermissions = new TreeSet<String>();
        dexterInstance.multiplePermissionsReport = new MultiplePermissionsReport();
        dexterInstance.isRequestingPermission = new AtomicBoolean();
        dexterInstance.rationaleAccepted = new AtomicBoolean();
        dexterInstance.isShowingNativeDialog = new AtomicBoolean();
        this.setContext(context);
    }

    private void requestPermissionsToSystem(Collection<String> activity) {
        if (!this.isShowingNativeDialog.get()) {
            Activity activity2 = activity;
            activity = this.activity;
            this.androidPermissionService.requestPermissions(activity, activity2.toArray(new String[0]), 42);
        }
        this.isShowingNativeDialog.set(true);
    }

    private PermissionStates getPermissionStates(Collection<String> object) {
        PermissionStates permissionStates;
        Collection<String> collection = object;
        object = permissionStates;
        permissionStates = new PermissionStates();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            DexterInstance dexterInstance = this;
            String string = iterator.next();
            int n = dexterInstance.checkSelfPermission(dexterInstance.activity, string);
            if (n != -2) {
                if (n != -1) {
                    ((PermissionStates)object).addGrantedPermission(string);
                    continue;
                }
                ((PermissionStates)object).addDeniedPermission(string);
                continue;
            }
            ((PermissionStates)object).addImpossibleToGrantPermission(string);
        }
        return object;
    }

    private int checkSelfPermission(Activity activity, String string) {
        try {
            return this.androidPermissionService.checkSelfPermission((Context)activity, string);
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    private void startTransparentActivityIfNeeded() {
        Context context = (Context)dexterInstance.context.get();
        if (context == null) {
            return;
        }
        DexterInstance dexterInstance = dexterInstance.intentProvider.get(context, DexterActivity.class);
        if (!(context instanceof Activity)) {
            dexterInstance.addFlags(0x10000000);
        }
        context.startActivity((Intent)dexterInstance);
    }

    private void handleDeniedPermissions(Collection<String> object) {
        LinkedList<PermissionRequest> linkedList;
        if (object.isEmpty()) {
            return;
        }
        LinkedList<PermissionRequest> linkedList2 = linkedList;
        linkedList = new LinkedList<PermissionRequest>();
        Iterator<String> iterator = object.iterator();
        while (iterator.hasNext()) {
            PermissionRequest permissionRequest;
            String string = iterator.next();
            if (!this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, string)) continue;
            PermissionRequest permissionRequest2 = permissionRequest;
            permissionRequest = new PermissionRequest(string);
            linkedList2.add(permissionRequest2);
        }
        if (linkedList2.isEmpty()) {
            this.requestPermissionsToSystem((Collection<String>)object);
        } else if (!this.rationaleAccepted.get()) {
            PermissionRationaleToken permissionRationaleToken;
            object = permissionRationaleToken;
            permissionRationaleToken = new PermissionRationaleToken(this);
            this.listener.onPermissionRationaleShouldBeShown(linkedList2, (PermissionToken)object);
        }
    }

    private void updatePermissionsAsGranted(Collection<String> collection) {
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            PermissionGrantedResponse permissionGrantedResponse = PermissionGrantedResponse.from(iterator.next());
            this.multiplePermissionsReport.addGrantedPermissionResponse(permissionGrantedResponse);
        }
        this.onPermissionsChecked(collection);
    }

    private void updatePermissionsAsDenied(Collection<String> collection) {
        for (String string : collection) {
            PermissionDeniedResponse object = PermissionDeniedResponse.from(string, this.androidPermissionService.isPermissionPermanentlyDenied(this.activity, string));
            this.multiplePermissionsReport.addDeniedPermissionResponse(object);
        }
        this.onPermissionsChecked(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onPermissionsChecked(Collection<String> collection) {
        if (this.pendingPermissions.isEmpty()) {
            return;
        }
        DexterInstance dexterInstance = this;
        Object object = dexterInstance.pendingPermissionsMutex;
        synchronized (object) {
            dexterInstance.pendingPermissions.removeAll(collection);
            {
                if (dexterInstance.pendingPermissions.isEmpty()) {
                    if (this.activity != null) {
                        this.activity.finish();
                    }
                    DexterInstance dexterInstance2 = this;
                    dexterInstance2.isRequestingPermission.set(false);
                    dexterInstance2.rationaleAccepted.set(false);
                    dexterInstance2.isShowingNativeDialog.set(false);
                    this.listener = EMPTY_LISTENER;
                    dexterInstance2.listener.onPermissionsChecked(this.multiplePermissionsReport);
                }
                return;
            }
        }
    }

    private void checkNoDexterRequestOngoing() {
        if (!this.isRequestingPermission.getAndSet(true)) {
            return;
        }
        throw new DexterException("Only one Dexter request at a time is allowed", DexterError.REQUEST_ONGOING);
    }

    private void checkRequestSomePermission(Collection<String> collection) {
        if (!collection.isEmpty()) {
            return;
        }
        throw new DexterException("Dexter has to be called with at least one permission", DexterError.NO_PERMISSIONS_REQUESTED);
    }

    private void checkSinglePermission(PermissionListener permissionListener, String string, Thread thread) {
        MultiplePermissionsListenerToPermissionListenerAdapter multiplePermissionsListenerToPermissionListenerAdapter;
        DexterInstance dexterInstance = multiplePermissionsListenerToPermissionListenerAdapter2;
        MultiplePermissionsListenerToPermissionListenerAdapter multiplePermissionsListenerToPermissionListenerAdapter2 = multiplePermissionsListenerToPermissionListenerAdapter;
        multiplePermissionsListenerToPermissionListenerAdapter = new MultiplePermissionsListenerToPermissionListenerAdapter(permissionListener);
        dexterInstance.checkMultiplePermissions(multiplePermissionsListenerToPermissionListenerAdapter2, Collections.singleton(string), thread);
    }

    private void checkMultiplePermissions(final MultiplePermissionsListener multiplePermissionsListener, final Collection<String> collection, Thread thread) {
        DexterInstance dexterInstance = this;
        this.checkNoDexterRequestOngoing();
        dexterInstance.checkRequestSomePermission(collection);
        if (dexterInstance.context.get() == null) {
            return;
        }
        Object object = this.activity;
        if (object != null && object.isFinishing()) {
            DexterInstance dexterInstance2 = this;
            dexterInstance2.onActivityDestroyed(dexterInstance2.activity);
        }
        DexterInstance dexterInstance3 = this;
        dexterInstance3.pendingPermissions.clear();
        dexterInstance3.pendingPermissions.addAll(collection);
        dexterInstance3.multiplePermissionsReport.clear();
        dexterInstance3.listener = new MultiplePermissionListenerThreadDecorator(multiplePermissionsListener, thread);
        if (this.isEveryPermissionGranted(collection, (Context)dexterInstance3.context.get())) {
            Runnable runnable;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    MultiplePermissionsReport multiplePermissionsReport;
                    MultiplePermissionsReport multiplePermissionsReport2 = multiplePermissionsReport;
                    multiplePermissionsReport = new MultiplePermissionsReport();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        multiplePermissionsReport2.addGrantedPermissionResponse(PermissionGrantedResponse.from((String)iterator.next()));
                    }
                    1 v1 = this;
                    v1.DexterInstance.this.isRequestingPermission.set(false);
                    v1.multiplePermissionsListener.onPermissionsChecked(multiplePermissionsReport2);
                    DexterInstance.access$702(v1.DexterInstance.this, EMPTY_LISTENER);
                }
            };
            thread.execute((Runnable)object);
        } else {
            this.startTransparentActivityIfNeeded();
        }
        thread.loop();
    }

    private boolean isEveryPermissionGranted(Collection<String> object, Context context) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (this.androidPermissionService.checkSelfPermission(context, string) == 0) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ MultiplePermissionsListener access$702(DexterInstance dexterInstance, MultiplePermissionsListener multiplePermissionsListener) {
        dexterInstance.listener = multiplePermissionsListener;
        return multiplePermissionsListener;
    }

    void setContext(Context context) {
        WeakReference<Context> weakReference;
        DexterInstance dexterInstance = weakReference2;
        WeakReference<Context> weakReference2 = weakReference;
        weakReference = new WeakReference<Context>(context);
        dexterInstance.context = weakReference2;
    }

    void checkPermission(PermissionListener permissionListener, String string, Thread thread) {
        this.checkSinglePermission(permissionListener, string, thread);
    }

    void checkPermissions(MultiplePermissionsListener multiplePermissionsListener, Collection<String> collection, Thread thread) {
        this.checkMultiplePermissions(multiplePermissionsListener, collection, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onActivityReady(Activity object) {
        Activity activity = this.activity = object;
        object = null;
        Object object2 = this.pendingPermissionsMutex;
        synchronized (object2) {
            if (activity != null) {
                DexterInstance dexterInstance = this;
                object = dexterInstance.getPermissionStates(dexterInstance.pendingPermissions);
            }
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
            if (object != null) {
                this.handleDeniedPermissions(((PermissionStates)object).getDeniedPermissions());
                this.updatePermissionsAsDenied(((PermissionStates)object).getImpossibleToGrantPermissions());
                this.updatePermissionsAsGranted(((PermissionStates)object).getGrantedPermissions());
            }
            return;
        }
    }

    void onActivityDestroyed(Activity activity) {
        if (this.activity == activity) {
            DexterInstance dexterInstance = this;
            dexterInstance.activity = null;
            dexterInstance.isRequestingPermission.set(false);
            dexterInstance.rationaleAccepted.set(false);
            dexterInstance.isShowingNativeDialog.set(false);
            dexterInstance.listener = EMPTY_LISTENER;
        }
    }

    void onPermissionRequestGranted(Collection<String> collection) {
        this.updatePermissionsAsGranted(collection);
    }

    void onPermissionRequestDenied(Collection<String> collection) {
        this.updatePermissionsAsDenied(collection);
    }

    void onContinuePermissionRequest() {
        DexterInstance dexterInstance = this;
        dexterInstance.rationaleAccepted.set(true);
        dexterInstance.requestPermissionsToSystem(dexterInstance.pendingPermissions);
    }

    void onCancelPermissionRequest() {
        DexterInstance dexterInstance = this;
        dexterInstance.rationaleAccepted.set(false);
        dexterInstance.updatePermissionsAsDenied(dexterInstance.pendingPermissions);
    }

    private final class PermissionStates {
        private final Collection<String> deniedPermissions;
        private final Collection<String> impossibleToGrantPermissions;
        private final Collection<String> grantedPermissions;

        private PermissionStates() {
            LinkedList linkedList;
            LinkedList linkedList2;
            LinkedList linkedList3;
            Object object = linkedList3;
            linkedList3 = new LinkedList();
            v1.deniedPermissions = object;
            object = linkedList2;
            linkedList2 = new LinkedList();
            v1.impossibleToGrantPermissions = object;
            object = linkedList;
            linkedList = new LinkedList();
            v1.grantedPermissions = object;
        }

        private void addDeniedPermission(String string) {
            this.deniedPermissions.add(string);
        }

        private void addImpossibleToGrantPermission(String string) {
            this.impossibleToGrantPermissions.add(string);
        }

        private void addGrantedPermission(String string) {
            this.grantedPermissions.add(string);
        }

        private Collection<String> getDeniedPermissions() {
            return this.deniedPermissions;
        }

        private Collection<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }

        public Collection<String> getImpossibleToGrantPermissions() {
            return this.impossibleToGrantPermissions;
        }
    }
}

