/*
 * Decompiled with CFR 0.152.
 */
package unirest.shaded.org.apache.http.protocol;

import java.io.IOException;
import unirest.shaded.org.apache.http.HttpEntityEnclosingRequest;
import unirest.shaded.org.apache.http.HttpException;
import unirest.shaded.org.apache.http.HttpRequest;
import unirest.shaded.org.apache.http.HttpRequestInterceptor;
import unirest.shaded.org.apache.http.annotation.Contract;
import unirest.shaded.org.apache.http.annotation.ThreadingBehavior;
import unirest.shaded.org.apache.http.protocol.HttpContext;
import unirest.shaded.org.apache.http.protocol.HttpDateGenerator;
import unirest.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

