/*
 * Decompiled with CFR 0.152.
 */
package com.kosprov.jargon2.internal;

import com.kosprov.jargon2.api.Jargon2;
import com.kosprov.jargon2.api.Jargon2Exception;
import com.kosprov.jargon2.internal.Jargon2BackendAdapter;
import com.kosprov.jargon2.internal.discovery.Jargon2BackendDiscovery;
import com.kosprov.jargon2.spi.Jargon2Backend;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VerifierImpl
implements Jargon2.Verifier {
    Jargon2Backend backend = Jargon2BackendDiscovery.INSTANCE.getJargon2Backend();
    Map<String, Object> options = Collections.emptyMap();
    Jargon2.Type type = Jargon2.Type.ARGON2i;
    Jargon2.Version version = Jargon2.Version.V13;
    int timeCost = 3;
    int memoryCost = 4096;
    int lanes = 1;
    int threads = 1;
    boolean autoThreads = true;
    byte[] salt;
    byte[] password;
    byte[] secret;
    byte[] ad;
    String encodedHash;
    byte[] rawHash;

    public VerifierImpl() {
    }

    private VerifierImpl(VerifierImpl copy) {
        this.backend = copy.backend;
        this.options = copy.options;
        this.type = copy.type;
        this.version = copy.version;
        this.timeCost = copy.timeCost;
        this.memoryCost = copy.memoryCost;
        this.lanes = copy.lanes;
        this.threads = copy.threads;
        this.autoThreads = copy.autoThreads;
        this.salt = copy.salt;
        this.password = copy.password;
        this.secret = copy.secret;
        this.ad = copy.ad;
        this.encodedHash = copy.encodedHash;
        this.rawHash = copy.rawHash;
    }

    @Override
    public VerifierImpl backend(Jargon2Backend backend) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.backend = backend;
        return copy;
    }

    @Override
    public VerifierImpl backend(String backendClass) {
        try {
            return this.backend(Class.forName(backendClass).asSubclass(Jargon2Backend.class));
        }
        catch (Exception e) {
            throw new Jargon2Exception("Could not create Jargon2Backend instance from class " + backendClass);
        }
    }

    @Override
    public VerifierImpl backend(Class<? extends Jargon2Backend> backendClass) {
        try {
            return this.backend(backendClass.newInstance());
        }
        catch (Exception e) {
            throw new Jargon2Exception("Could not create Jargon2Backend instance from class " + backendClass);
        }
    }

    @Override
    public VerifierImpl options(Map<String, Object> options) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.options = options != null ? new HashMap<String, Object>(options) : Collections.emptyMap();
        return copy;
    }

    @Override
    public VerifierImpl type(Jargon2.Type type) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.type = type;
        return copy;
    }

    @Override
    public VerifierImpl version(Jargon2.Version version) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.version = version;
        return copy;
    }

    @Override
    public VerifierImpl timeCost(int timeCost) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.timeCost = timeCost;
        return copy;
    }

    @Override
    public VerifierImpl memoryCost(int memoryCost) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.memoryCost = memoryCost;
        return copy;
    }

    @Override
    public VerifierImpl parallelism(int parallelism) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.lanes = parallelism;
        copy.threads = parallelism;
        copy.autoThreads = false;
        return copy;
    }

    @Override
    public VerifierImpl parallelism(int lanes, int threads) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.lanes = lanes;
        copy.threads = threads;
        copy.autoThreads = false;
        return copy;
    }

    @Override
    public VerifierImpl threads(int threads) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.threads = threads;
        copy.autoThreads = false;
        return copy;
    }

    @Override
    public VerifierImpl salt(byte[] salt) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.salt = salt;
        return copy;
    }

    @Override
    public VerifierImpl salt(Jargon2.ByteArray salt) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.salt = salt.getBytes();
        return copy;
    }

    @Override
    public VerifierImpl password(byte[] password) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.password = password;
        return copy;
    }

    @Override
    public VerifierImpl password(Jargon2.ByteArray password) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.password = password.getBytes();
        return copy;
    }

    @Override
    public VerifierImpl secret(byte[] secret) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.secret = secret;
        return copy;
    }

    @Override
    public VerifierImpl secret(Jargon2.ByteArray secret) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.secret = secret.getBytes();
        return copy;
    }

    @Override
    public VerifierImpl ad(byte[] ad) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.ad = ad;
        return copy;
    }

    @Override
    public VerifierImpl ad(Jargon2.ByteArray ad) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.ad = ad.getBytes();
        return copy;
    }

    @Override
    public EncodedVerifierImpl hash(String encodedHash) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.encodedHash = encodedHash;
        copy.rawHash = null;
        return new EncodedVerifierImpl(copy);
    }

    @Override
    public RawVerifierImpl hash(byte[] rawHash) {
        VerifierImpl copy = new VerifierImpl(this);
        copy.rawHash = rawHash;
        copy.encodedHash = null;
        return new RawVerifierImpl(copy);
    }

    public String toString() {
        return "Verifier{backend=" + this.backend.getClass().getName() + ", options=" + this.options.size() + " item(s), type=" + (Object)((Object)this.type) + ", version=" + (Object)((Object)this.version) + ", timeCost=" + this.timeCost + ", memoryCost=" + this.memoryCost + ", lanes=" + this.lanes + ", threads=" + this.threads + '}';
    }

    private static class RawVerifierImpl
    implements Jargon2.RawVerifier {
        private final VerifierImpl delegate;

        RawVerifierImpl(VerifierImpl verifier) {
            this.delegate = verifier;
        }

        @Override
        public RawVerifierImpl backend(Jargon2Backend backend) {
            return new RawVerifierImpl(this.delegate.backend(backend));
        }

        @Override
        public RawVerifierImpl backend(String backendClass) {
            return new RawVerifierImpl(this.delegate.backend(backendClass));
        }

        @Override
        public RawVerifierImpl backend(Class<? extends Jargon2Backend> backendClass) {
            return new RawVerifierImpl((VerifierImpl)this.delegate.backend((Class)backendClass));
        }

        @Override
        public RawVerifierImpl options(Map<String, Object> options) {
            return new RawVerifierImpl((VerifierImpl)this.delegate.options((Map)options));
        }

        @Override
        public RawVerifierImpl type(Jargon2.Type type) {
            return new RawVerifierImpl(this.delegate.type(type));
        }

        @Override
        public RawVerifierImpl version(Jargon2.Version version) {
            return new RawVerifierImpl(this.delegate.version(version));
        }

        @Override
        public RawVerifierImpl timeCost(int timeCost) {
            return new RawVerifierImpl(this.delegate.timeCost(timeCost));
        }

        @Override
        public RawVerifierImpl memoryCost(int memoryCost) {
            return new RawVerifierImpl(this.delegate.memoryCost(memoryCost));
        }

        @Override
        public RawVerifierImpl parallelism(int parallelism) {
            return new RawVerifierImpl(this.delegate.parallelism(parallelism));
        }

        @Override
        public RawVerifierImpl parallelism(int lanes, int threads) {
            return new RawVerifierImpl(this.delegate.parallelism(lanes, threads));
        }

        @Override
        public RawVerifierImpl threads(int threads) {
            return new RawVerifierImpl(this.delegate.threads(threads));
        }

        @Override
        public RawVerifierImpl salt(byte[] salt) {
            return new RawVerifierImpl(this.delegate.salt(salt));
        }

        @Override
        public RawVerifierImpl salt(Jargon2.ByteArray salt) {
            return new RawVerifierImpl(this.delegate.salt(salt));
        }

        @Override
        public RawVerifierImpl password(byte[] password) {
            return new RawVerifierImpl(this.delegate.password(password));
        }

        @Override
        public RawVerifierImpl password(Jargon2.ByteArray password) {
            return new RawVerifierImpl(this.delegate.password(password));
        }

        @Override
        public RawVerifierImpl secret(byte[] secret) {
            return new RawVerifierImpl(this.delegate.secret(secret));
        }

        @Override
        public RawVerifierImpl secret(Jargon2.ByteArray secret) {
            return new RawVerifierImpl(this.delegate.secret(secret));
        }

        @Override
        public RawVerifierImpl ad(byte[] ad) {
            return new RawVerifierImpl(this.delegate.ad(ad));
        }

        @Override
        public RawVerifierImpl ad(Jargon2.ByteArray ad) {
            return new RawVerifierImpl(this.delegate.ad(ad));
        }

        @Override
        public EncodedVerifierImpl hash(String encodedHash) {
            return this.delegate.hash(encodedHash);
        }

        @Override
        public RawVerifierImpl hash(byte[] rawHash) {
            return this.delegate.hash(rawHash);
        }

        @Override
        public boolean verifyRaw() {
            int threads = this.delegate.autoThreads ? this.delegate.lanes : this.delegate.threads;
            return new Jargon2BackendAdapter(this.delegate.backend).verifyRaw(this.delegate.type, this.delegate.version, this.delegate.memoryCost, this.delegate.timeCost, this.delegate.lanes, threads, this.delegate.rawHash, this.delegate.secret, this.delegate.ad, this.delegate.salt, this.delegate.password, this.delegate.options);
        }
    }

    private static class EncodedVerifierImpl
    implements Jargon2.EncodedVerifier {
        private final VerifierImpl delegate;

        EncodedVerifierImpl(VerifierImpl verifier) {
            this.delegate = verifier;
        }

        @Override
        public EncodedVerifierImpl backend(Jargon2Backend backend) {
            return new EncodedVerifierImpl(this.delegate.backend(backend));
        }

        @Override
        public EncodedVerifierImpl backend(String backendClass) {
            return new EncodedVerifierImpl(this.delegate.backend(backendClass));
        }

        @Override
        public EncodedVerifierImpl backend(Class<? extends Jargon2Backend> backendClass) {
            return new EncodedVerifierImpl((VerifierImpl)this.delegate.backend((Class)backendClass));
        }

        @Override
        public EncodedVerifierImpl options(Map<String, Object> options) {
            return new EncodedVerifierImpl((VerifierImpl)this.delegate.options((Map)options));
        }

        @Override
        public EncodedVerifierImpl type(Jargon2.Type type) {
            return new EncodedVerifierImpl(this.delegate.type(type));
        }

        @Override
        public EncodedVerifierImpl version(Jargon2.Version version) {
            return new EncodedVerifierImpl(this.delegate.version(version));
        }

        @Override
        public EncodedVerifierImpl timeCost(int timeCost) {
            return new EncodedVerifierImpl(this.delegate.timeCost(timeCost));
        }

        @Override
        public EncodedVerifierImpl memoryCost(int memoryCost) {
            return new EncodedVerifierImpl(this.delegate.memoryCost(memoryCost));
        }

        @Override
        public EncodedVerifierImpl parallelism(int parallelism) {
            return new EncodedVerifierImpl(this.delegate.parallelism(parallelism));
        }

        @Override
        public EncodedVerifierImpl parallelism(int lanes, int threads) {
            return new EncodedVerifierImpl(this.delegate.parallelism(lanes, threads));
        }

        @Override
        public EncodedVerifierImpl threads(int threads) {
            return new EncodedVerifierImpl(this.delegate.threads(threads));
        }

        @Override
        public EncodedVerifierImpl salt(byte[] salt) {
            return new EncodedVerifierImpl(this.delegate.salt(salt));
        }

        @Override
        public EncodedVerifierImpl salt(Jargon2.ByteArray salt) {
            return new EncodedVerifierImpl(this.delegate.salt(salt));
        }

        @Override
        public EncodedVerifierImpl password(byte[] password) {
            return new EncodedVerifierImpl(this.delegate.password(password));
        }

        @Override
        public EncodedVerifierImpl password(Jargon2.ByteArray password) {
            return new EncodedVerifierImpl(this.delegate.password(password));
        }

        @Override
        public EncodedVerifierImpl secret(byte[] secret) {
            return new EncodedVerifierImpl(this.delegate.secret(secret));
        }

        @Override
        public EncodedVerifierImpl secret(Jargon2.ByteArray secret) {
            return new EncodedVerifierImpl(this.delegate.secret(secret));
        }

        @Override
        public EncodedVerifierImpl ad(byte[] ad) {
            return new EncodedVerifierImpl(this.delegate.ad(ad));
        }

        @Override
        public EncodedVerifierImpl ad(Jargon2.ByteArray ad) {
            return new EncodedVerifierImpl(this.delegate.ad(ad));
        }

        @Override
        public EncodedVerifierImpl hash(String encodedHash) {
            return this.delegate.hash(encodedHash);
        }

        @Override
        public RawVerifierImpl hash(byte[] rawHash) {
            return this.delegate.hash(rawHash);
        }

        @Override
        public boolean verifyEncoded() {
            if (this.delegate.autoThreads) {
                return new Jargon2BackendAdapter(this.delegate.backend).verifyEncoded(this.delegate.encodedHash, this.delegate.secret, this.delegate.ad, this.delegate.password, this.delegate.options);
            }
            return new Jargon2BackendAdapter(this.delegate.backend).verifyEncoded(this.delegate.encodedHash, this.delegate.threads, this.delegate.secret, this.delegate.ad, this.delegate.password, this.delegate.options);
        }
    }
}

