/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.document_ai.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.document_ai.v1.model.RecognizeBusinessLicenseReq;
import com.lark.oapi.service.document_ai.v1.model.RecognizeBusinessLicenseResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessLicense {
    private static final Logger log = LoggerFactory.getLogger(BusinessLicense.class);
    private final Config config;

    public BusinessLicense(Config config) {
        this.config = config;
    }

    public RecognizeBusinessLicenseResp recognize(RecognizeBusinessLicenseReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/business_license/recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
        RecognizeBusinessLicenseResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeBusinessLicenseResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/business_license/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public RecognizeBusinessLicenseResp recognize(RecognizeBusinessLicenseReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/business_license/recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
        RecognizeBusinessLicenseResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeBusinessLicenseResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/business_license/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

