/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.helpdesk.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSchedulesResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSchedules {
    private static final Logger log = LoggerFactory.getLogger(AgentSchedules.class);
    private final Config config;

    public AgentSchedules(Config config) {
        this.config = config;
    }

    public DeleteAgentSchedulesResp delete(DeleteAgentSchedulesReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req);
        DeleteAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteAgentSchedulesResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public DeleteAgentSchedulesResp delete(DeleteAgentSchedulesReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req);
        DeleteAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteAgentSchedulesResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetAgentSchedulesResp get(GetAgentSchedulesReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.Tenant), req);
        GetAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAgentSchedulesResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetAgentSchedulesResp get(GetAgentSchedulesReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.Tenant), req);
        GetAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAgentSchedulesResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public PatchAgentSchedulesResp patch(PatchAgentSchedulesReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req);
        PatchAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentSchedulesResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public PatchAgentSchedulesResp patch(PatchAgentSchedulesReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Sets.newHashSet(AccessTokenType.User), req);
        PatchAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentSchedulesResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id/schedules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

