/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.filters;

import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.core.DocumentationError;
import java.util.List;
import org.springframework.web.method.HandlerMethod;

public class AnnotatedErrorsFilter
implements Filter<List<DocumentationError>> {
    @Override
    public void apply(FilterContext<List<DocumentationError>> context) {
        List<DocumentationError> errors = context.subject();
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        this.discoverSwaggerAnnotatedExceptions(errors, handlerMethod);
    }

    private void discoverSwaggerAnnotatedExceptions(List<DocumentationError> errors, HandlerMethod handlerMethod) {
        ApiErrors apiErrors = (ApiErrors)handlerMethod.getMethodAnnotation(ApiErrors.class);
        if (apiErrors == null) {
            return;
        }
        for (ApiError apiError : apiErrors.value()) {
            errors.add(new DocumentationError(apiError.code(), apiError.reason()));
        }
    }
}

