/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.Objects;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.TypeProcessingRule;
import com.mangofactory.swagger.models.WildcardType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public final class AlternateTypeProcessingRule
implements TypeProcessingRule {
    private ResolvedType alternateType;
    private ResolvedType originalType;

    public AlternateTypeProcessingRule(Class<?> originalType, Class<?> alternateType) {
        this.alternateType = ResolvedTypes.asResolvedType(alternateType);
        this.originalType = ResolvedTypes.asResolvedType(originalType);
    }

    public AlternateTypeProcessingRule(ResolvedType originalType, ResolvedType alternateType) {
        this.alternateType = alternateType;
        this.originalType = originalType;
    }

    @Override
    public boolean isIgnorable() {
        return false;
    }

    @Override
    public boolean hasAlternateType() {
        return !Objects.equal((Object)this.originalType, (Object)this.alternateType);
    }

    @Override
    public ResolvedType originalType() {
        return this.originalType;
    }

    @Override
    public ResolvedType alternateType(ResolvedType parameterType) {
        if (WildcardType.hasWildcards(this.originalType)) {
            return WildcardType.replaceWildcardsFrom(WildcardType.collectReplaceables(parameterType, this.originalType), this.alternateType);
        }
        return this.alternateType;
    }

    public static AlternateTypeProcessingRule alternate(ResolvedType original, ResolvedType alternate) {
        return new AlternateTypeProcessingRule(original, alternate);
    }

    public static AlternateTypeProcessingRule hashmapAlternate(Class<?> key, Class<?> value) {
        TypeResolver resolver = new TypeResolver();
        return AlternateTypeProcessingRule.alternate(resolver.resolve(Map.class, new Type[]{key, value}), resolver.resolve(List.class, new Type[]{resolver.resolve(Entry.class, new Type[]{key, value})}));
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    class Entry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        Entry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            return this.value;
        }
    }
}

