/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.types.ResolvedArrayType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mangofactory.swagger.models.MemberInfoSource;
import com.mangofactory.swagger.models.MemberVisitor;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.SchemaProvider;
import com.wordnik.swagger.core.DocumentationSchema;

public class ResolvedArrayMemberVisitor
implements MemberVisitor {
    private final SchemaProvider context;

    public ResolvedArrayMemberVisitor(SchemaProvider context) {
        this.context = context;
    }

    public static Function<SchemaProvider, MemberVisitor> factory() {
        return new Function<SchemaProvider, MemberVisitor>(){

            public MemberVisitor apply(SchemaProvider input) {
                return new ResolvedArrayMemberVisitor(input);
            }
        };
    }

    @Override
    public DocumentationSchema schema(MemberInfoSource member) {
        Preconditions.checkArgument((boolean)(member.getResolvedType() instanceof ResolvedArrayType));
        if (this.context.getSchemaMap().containsKey(member.getType().getSimpleName())) {
            DocumentationSchema schema = new DocumentationSchema();
            schema.setType(ResolvedTypes.modelName(member.getResolvedType()));
            schema.setName(member.getName());
            return schema;
        }
        ResolvedArrayType resolvedArrayType = (ResolvedArrayType)member.getResolvedType();
        DocumentationSchema schema = new DocumentationSchema();
        schema.setType("Array");
        schema.setName(member.getName());
        DocumentationSchema itemSchema = this.context.schema(resolvedArrayType.getArrayElementType());
        DocumentationSchema itemSchemaRef = new DocumentationSchema();
        itemSchemaRef.ref_$eq(itemSchema.getType());
        schema.setItems(itemSchemaRef);
        return schema;
    }
}

