/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeBindings;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WildcardType {
    public static boolean hasWildcards(ResolvedType type) {
        return Iterables.any((Iterable)type.getTypeBindings().getTypeParameters(), (Predicate)new Predicate<ResolvedType>(){

            public boolean apply(ResolvedType input) {
                return WildcardType.class.equals((Object)input.getErasedType());
            }
        });
    }

    public static boolean exactMatch(ResolvedType first, ResolvedType second) {
        return first.equals((Object)second);
    }

    public static boolean wildcardMatch(ResolvedType toMatch, ResolvedType wildcardType) {
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings bindingsToMatch = toMatch.getTypeBindings();
        if (bindingsToMatch.size() != wildcardTypeBindings.size()) {
            return false;
        }
        for (int index = 0; index < bindingsToMatch.size(); ++index) {
            if (wildcardTypeBindings.getBoundType(index).getErasedType().equals(WildcardType.class) || wildcardTypeBindings.getBoundType(index).equals((Object)bindingsToMatch.getBoundType(index))) continue;
            return false;
        }
        return true;
    }

    static ResolvedType replaceWildcardsFrom(Iterable<ResolvedType> replaceables, ResolvedType wildcardType) {
        Iterator<ResolvedType> replaceableIterator = replaceables.iterator();
        return WildcardType.breadthFirstReplace(replaceableIterator, wildcardType);
    }

    private static ResolvedType breadthFirstReplace(Iterator<ResolvedType> replaceableIterator, ResolvedType wildcardType) {
        if (WildcardType.class.equals((Object)wildcardType.getErasedType())) {
            if (replaceableIterator.hasNext()) {
                return replaceableIterator.next();
            }
            throw new IllegalStateException("Expecting the same number of wildcard types as the replaceables");
        }
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        ArrayList bindings = Lists.newArrayList();
        for (int index = 0; index < wildcardTypeBindings.size(); ++index) {
            if (WildcardType.class.equals((Object)wildcardTypeBindings.getBoundType(index).getErasedType())) {
                if (replaceableIterator.hasNext()) {
                    bindings.add(replaceableIterator.next());
                    continue;
                }
                throw new IllegalStateException("Count of wildcards to candidates do not match");
            }
            bindings.add(WildcardType.breadthFirstReplace(replaceableIterator, wildcardTypeBindings.getBoundType(index)));
        }
        return new TypeResolver().resolve((Type)wildcardType.getErasedType(), (Type[])Iterables.toArray((Iterable)bindings, Type.class));
    }

    static List<ResolvedType> collectReplaceables(ResolvedType replacingType, ResolvedType wildcardType) {
        return WildcardType.breadthFirstSearch(replacingType, wildcardType);
    }

    private static List<ResolvedType> breadthFirstSearch(ResolvedType replacingType, ResolvedType wildcardType) {
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings bindingsToMatch = replacingType.getTypeBindings();
        Preconditions.checkArgument((bindingsToMatch.size() == wildcardTypeBindings.size() ? 1 : 0) != 0);
        ArrayList bindings = Lists.newArrayList();
        for (int index = 0; index < bindingsToMatch.size(); ++index) {
            if (WildcardType.class.equals((Object)wildcardTypeBindings.getBoundType(index).getErasedType())) {
                bindings.add(bindingsToMatch.getBoundType(index));
                continue;
            }
            bindings.addAll(WildcardType.breadthFirstSearch(bindingsToMatch.getBoundType(index), wildcardTypeBindings.getBoundType(index)));
        }
        return bindings;
    }
}

