/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.spring.Descriptions;
import com.mangofactory.swagger.spring.UriBuilder;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class UriExtractor {
    private static final Logger log = LoggerFactory.getLogger(UriExtractor.class);

    public static List<String> controllerUris(Class<?> controllerClass) {
        ArrayList controllerUris = Lists.newArrayList();
        List<String> classLevelUris = UriExtractor.resolveRequestUri(controllerClass, UriExtractor.requestMapping(controllerClass));
        String defaultUri = Descriptions.splitCamelCase(controllerClass.getSimpleName(), "-").toLowerCase();
        if (classLevelUris.isEmpty()) {
            classLevelUris.add("/" + defaultUri);
        }
        for (String classLevelUri : classLevelUris) {
            if (Strings.isNullOrEmpty((String)classLevelUri)) {
                classLevelUri = "/" + defaultUri;
            }
            if (!classLevelUri.startsWith("/")) {
                classLevelUri = String.format("/%s", classLevelUri);
            }
            UriBuilder builder = new UriBuilder();
            UriExtractor.maybeAppendPath(builder, classLevelUri);
            controllerUris.add(builder.toString());
        }
        return controllerUris;
    }

    public static List<String> methodUris(Class<?> controllerClass, HandlerMethod handlerMethod) {
        List<String> classLevelUris = UriExtractor.resolveRequestUri(controllerClass, UriExtractor.requestMapping(controllerClass));
        if (classLevelUris.isEmpty()) {
            classLevelUris.add("/");
        }
        ArrayList methodLevelUris = Lists.newArrayList();
        for (String classLevelUri : classLevelUris) {
            if (!classLevelUri.startsWith("/")) {
                classLevelUri = String.format("/%s", classLevelUri);
            }
            UriBuilder builder = new UriBuilder();
            UriExtractor.maybeAppendPath(builder, classLevelUri);
            for (String methodLevelUri : UriExtractor.resolveRequestUri(controllerClass, UriExtractor.requestMapping(handlerMethod.getMethod()))) {
                UriExtractor.maybeAppendPath(builder, methodLevelUri);
            }
            methodLevelUris.add(builder.toString());
        }
        return methodLevelUris;
    }

    private static void maybeAppendPath(UriBuilder builder, String toAppendUri) {
        if (!Strings.isNullOrEmpty((String)toAppendUri)) {
            builder.appendPath(toAppendUri);
        }
    }

    private static RequestMapping requestMapping(AnnotatedElement annotated) {
        return annotated.getAnnotation(RequestMapping.class);
    }

    protected static List<String> resolveRequestUri(Class clazz, RequestMapping requestMapping) {
        if (requestMapping == null) {
            log.debug("Class {} has no @RequestMapping", (Object)clazz);
            return Lists.newArrayList();
        }
        Object[] requestUris = requestMapping.value();
        if (requestUris == null || requestUris.length == 0) {
            log.warn("Class {} contains a @RequestMapping, but could not resolve the uri", (Object)clazz);
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])requestUris);
    }
}

