package com.microsoft.azure.management.apigeneration;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(RetentionPolicy.CLASS)
@Target({ TYPE, METHOD, PARAMETER, CONSTRUCTOR })
@Inherited
/**
 * Indicates functionality that is in preview and as such is subject to change in non-backwards compatible ways in future releases,
 * including removal, regardless of any compatibility expectations set by the containing library version.
 */
public @interface Beta {
    String warningText() default "This functionality is in preview and as such is subject to change in non-backwards compatible ways in future releases, including removal, regardless of any compatibility expectations set by the containing library version.";

    /**
     * @return the version number when the annotated API was first introduced to the library as in Beta
     */
    SinceVersion value() default SinceVersion.V1_1_0;

    /**
     * Azure library version numbers
     */
    public enum SinceVersion {
        /** v1.0.0 */
        V1_0_0,

        /** v1.1.0 */
        V1_1_0,

        /** v1.2.0 */
        V1_2_0,

        /** v1.3.0 */
        V1_3_0,

        /** v1.4.0 */
        V1_4_0,

        /** v1.4.1 */
        V1_4_1,

        /** v1.4.2 */
        V1_4_2,

        /** v1.5.0 */
        V1_5_0,

        /** v1.5.1 */
        V1_5_1,

        /** v1.6.0 */
        V1_6_0,

        /** v1.7.0 */
        V1_7_0,

        /** v1.8.0 */
        V1_8_0,

        /** v1.9.0 */
        V1_9_0,

        /** v1.10.0 */
        V1_10_0,

        /** v1.11.0 */
        V1_11_0,

        /** v1.12.0 */
        V1_12_0,

        /** v1.13.0 */
        V1_13_0,

        /** v1.14.0 */
        V1_14_0,

        /** v1.15.0 */
        V1_15_0,

        /** v1.16.0 */
        V1_16_0,

        /** v1.17.0 */
        V1_17_0,

        /** v1.18.0 */
        V1_18_0,

        /** v1.19.0 */
        V1_19_0,

        /** v1.20.0 */
        V1_20_0,

        /** v1.21.0 */
        V1_21_0,

        /** v1.22.0 */
        V1_22_0,

        /** v1.23.0 */
        V1_23_0,

        /** v1.24.0 */
        V1_24_0,

        /** v1.25.0 */
        V1_25_0,

        /** v2.0.0 */
        V2_0_0
    }
}
