/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.MSIToken;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

@Beta
public class AppServiceMSICredentials
extends AzureTokenCredentials {
    private final String endpoint;
    private final String secret;
    private final AzureJacksonAdapter adapter;

    public AppServiceMSICredentials(AzureEnvironment environment) {
        this(environment, System.getenv("MSI_ENDPOINT"), System.getenv("MSI_SECRET"));
    }

    public AppServiceMSICredentials(AzureEnvironment environment, String endpoint, String secret) {
        super(environment, null);
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint == null");
        }
        if (secret == null) {
            throw new IllegalArgumentException("secret == null");
        }
        this.endpoint = endpoint;
        this.secret = secret;
        this.adapter = new AzureJacksonAdapter();
    }

    public String getToken(String resource) throws IOException {
        String urlString = String.format("%s?resource=%s&api-version=2017-09-01", this.endpoint, resource);
        URL url = new URL(urlString);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Secret", this.secret);
            connection.setRequestProperty("Metadata", "true");
            connection.connect();
            InputStream stream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"), 100);
            String result = reader.readLine();
            MSIToken msiToken = (MSIToken)this.adapter.deserialize(result, MSIToken.class);
            String string = msiToken.accessToken();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

