/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * ARM Usage Name.
 */
public class Name {
    /**
     * Usage name value.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Usage name localized value.
     */
    @JsonProperty(value = "localizedValue")
    private String localizedValue;

    /**
     * Get usage name value.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set usage name value.
     *
     * @param value the value value to set
     * @return the Name object itself.
     */
    public Name withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get usage name localized value.
     *
     * @return the localizedValue value
     */
    public String localizedValue() {
        return this.localizedValue;
    }

    /**
     * Set usage name localized value.
     *
     * @param localizedValue the localizedValue value to set
     * @return the Name object itself.
     */
    public Name withLocalizedValue(String localizedValue) {
        this.localizedValue = localizedValue;
        return this;
    }

}
