/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Partner region information for the failover group.
 */
public class PartnerRegionInfo {
    /**
     * Geo location of the partner managed instances.
     */
    @JsonProperty(value = "location")
    private String location;

    /**
     * Replication role of the partner managed instances. Possible values
     * include: 'Primary', 'Secondary'.
     */
    @JsonProperty(value = "replicationRole", access = JsonProperty.Access.WRITE_ONLY)
    private InstanceFailoverGroupReplicationRole replicationRole;

    /**
     * Get geo location of the partner managed instances.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set geo location of the partner managed instances.
     *
     * @param location the location value to set
     * @return the PartnerRegionInfo object itself.
     */
    public PartnerRegionInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get replication role of the partner managed instances. Possible values include: 'Primary', 'Secondary'.
     *
     * @return the replicationRole value
     */
    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

}
