/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.microsoft.azure.management.sql.VulnerabilityAssessmentPolicyBaselineName;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DatabaseVulnerabilityAssessmentRuleBaselines.
 */
public class DatabaseVulnerabilityAssessmentRuleBaselinesInner {
    /** The Retrofit service to perform REST calls. */
    private DatabaseVulnerabilityAssessmentRuleBaselinesService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of DatabaseVulnerabilityAssessmentRuleBaselinesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselinesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(DatabaseVulnerabilityAssessmentRuleBaselinesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DatabaseVulnerabilityAssessmentRuleBaselines to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DatabaseVulnerabilityAssessmentRuleBaselinesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentRuleBaselines get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("ruleId") String ruleId, @Path("baselineName") VulnerabilityAssessmentPolicyBaselineName baselineName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentRuleBaselines createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("ruleId") String ruleId, @Path("baselineName") VulnerabilityAssessmentPolicyBaselineName baselineName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body DatabaseVulnerabilityAssessmentRuleBaselineInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentRuleBaselines delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("ruleId") String ruleId, @Path("baselineName") VulnerabilityAssessmentPolicyBaselineName baselineName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineInner object if successful.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner get(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName).toBlocking().single().body();
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, final ServiceCallback<DatabaseVulnerabilityAssessmentRuleBaselineInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName), serviceCallback);
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentRuleBaselineInner object
     */
    public Observable<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName).map(new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>, DatabaseVulnerabilityAssessmentRuleBaselineInner>() {
            @Override
            public DatabaseVulnerabilityAssessmentRuleBaselineInner call(ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentRuleBaselineInner object
     */
    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (ruleId == null) {
            throw new IllegalArgumentException("Parameter ruleId is required and cannot be null.");
        }
        if (baselineName == null) {
            throw new IllegalArgumentException("Parameter baselineName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseVulnerabilityAssessmentRuleBaselineInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseVulnerabilityAssessmentRuleBaselineInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @param baselineResults The rule baseline result
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineInner object if successful.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName, baselineResults).toBlocking().single().body();
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @param baselineResults The rule baseline result
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults, final ServiceCallback<DatabaseVulnerabilityAssessmentRuleBaselineInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName, baselineResults), serviceCallback);
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @param baselineResults The rule baseline result
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentRuleBaselineInner object
     */
    public Observable<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName, baselineResults).map(new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>, DatabaseVulnerabilityAssessmentRuleBaselineInner>() {
            @Override
            public DatabaseVulnerabilityAssessmentRuleBaselineInner call(ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @param baselineResults The rule baseline result
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentRuleBaselineInner object
     */
    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (ruleId == null) {
            throw new IllegalArgumentException("Parameter ruleId is required and cannot be null.");
        }
        if (baselineName == null) {
            throw new IllegalArgumentException("Parameter baselineName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (baselineResults == null) {
            throw new IllegalArgumentException("Parameter baselineResults is required and cannot be null.");
        }
        Validator.validate(baselineResults);
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-03-01-preview";
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters = new DatabaseVulnerabilityAssessmentRuleBaselineInner();
        parameters.withBaselineResults(baselineResults);
        return service.createOrUpdate(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseVulnerabilityAssessmentRuleBaselineInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseVulnerabilityAssessmentRuleBaselineInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName).toBlocking().single().body();
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName), serviceCallback);
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, ruleId, baselineName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). Possible values include: 'master', 'default'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (ruleId == null) {
            throw new IllegalArgumentException("Parameter ruleId is required and cannot be null.");
        }
        if (baselineName == null) {
            throw new IllegalArgumentException("Parameter baselineName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-03-01-preview";
        return service.delete(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
