/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in JobTargetExecutions.
 */
public class JobTargetExecutionsInner {
    /** The Retrofit service to perform REST calls. */
    private JobTargetExecutionsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of JobTargetExecutionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public JobTargetExecutionsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(JobTargetExecutionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for JobTargetExecutions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface JobTargetExecutionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByJobExecution" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/targets")
        Observable<Response<ResponseBody>> listByJobExecution(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("subscriptionId") String subscriptionId, @Query("createTimeMin") DateTime createTimeMin, @Query("createTimeMax") DateTime createTimeMax, @Query("endTimeMin") DateTime endTimeMin, @Query("endTimeMax") DateTime endTimeMax, @Query("isActive") Boolean isActive, @Query("$skip") Integer skip, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByStep" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}/targets")
        Observable<Response<ResponseBody>> listByStep(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("stepName") String stepName, @Path("subscriptionId") String subscriptionId, @Query("createTimeMin") DateTime createTimeMin, @Query("createTimeMax") DateTime createTimeMax, @Query("endTimeMin") DateTime endTimeMin, @Query("endTimeMax") DateTime endTimeMax, @Query("isActive") Boolean isActive, @Query("$skip") Integer skip, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}/targets/{targetId}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("stepName") String stepName, @Path("targetId") UUID targetId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByJobExecutionNext" })
        @GET
        Observable<Response<ResponseBody>> listByJobExecutionNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByStepNext" })
        @GET
        Observable<Response<ResponseBody>> listByStepNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByJobExecution(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId) {
        ServiceResponse<Page<JobExecutionInner>> response = listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByJobExecutionAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByJobExecutionNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByJobExecutionAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId) {
        return listByJobExecutionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId) {
        return listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByJobExecutionNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        final DateTime createTimeMin = null;
        final DateTime createTimeMax = null;
        final DateTime endTimeMin = null;
        final DateTime endTimeMax = null;
        final Boolean isActive = null;
        final Integer skip = null;
        final Integer top = null;
        return service.listByJobExecution(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByJobExecutionDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByJobExecution(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        ServiceResponse<Page<JobExecutionInner>> response = listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByJobExecutionAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByJobExecutionNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByJobExecutionAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByJobExecutionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByJobExecutionNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobAgentName The name of the job agent.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobName The name of the job to get.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobExecutionId The id of the job execution
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMin If specified, only job executions created at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMax If specified, only job executions created before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMax If specified, only job executions completed before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param isActive If specified, only active or only completed job executions are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param skip The number of elements in the collection to skip.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByJobExecution(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByJobExecutionDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobExecutionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByStep(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName) {
        ServiceResponse<Page<JobExecutionInner>> response = listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByStepNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByStepAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByStepNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByStepAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName) {
        return listByStepWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName) {
        return listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByStepNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        final DateTime createTimeMin = null;
        final DateTime createTimeMax = null;
        final DateTime endTimeMin = null;
        final DateTime endTimeMax = null;
        final Boolean isActive = null;
        final Integer skip = null;
        final Integer top = null;
        return service.listByStep(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByStepDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByStep(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        ServiceResponse<Page<JobExecutionInner>> response = listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByStepNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByStepAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByStepNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByStepAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByStepWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution
     * @param stepName The name of the step.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByStepNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobAgentName The name of the job agent.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobName The name of the job to get.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobExecutionId The id of the job execution
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param stepName The name of the step.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMin If specified, only job executions created at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMax If specified, only job executions created before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMax If specified, only job executions completed before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param isActive If specified, only active or only completed job executions are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param skip The number of elements in the collection to skip.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final UUID jobExecutionId, final String stepName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByStep(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByStepDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByStepDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a target execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution
     * @param stepName The name of the step.
     * @param targetId The target id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobExecutionInner object if successful.
     */
    public JobExecutionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId).toBlocking().single().body();
    }

    /**
     * Gets a target execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution
     * @param stepName The name of the step.
     * @param targetId The target id.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId, final ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId), serviceCallback);
    }

    /**
     * Gets a target execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution
     * @param stepName The name of the step.
     * @param targetId The target id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId).map(new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>() {
            @Override
            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a target execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution
     * @param stepName The name of the step.
     * @param targetId The target id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<ServiceResponse<JobExecutionInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("Parameter targetId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>() {
                @Override
                public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobExecutionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobExecutionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobExecutionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobExecutionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByJobExecutionNext(final String nextPageLink) {
        ServiceResponse<Page<JobExecutionInner>> response = listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByJobExecutionNextAsync(final String nextPageLink, final ServiceFuture<List<JobExecutionInner>> serviceFuture, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByJobExecutionNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByJobExecutionNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByJobExecutionNextAsync(final String nextPageLink) {
        return listByJobExecutionNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionNextWithServiceResponseAsync(final String nextPageLink) {
        return listByJobExecutionNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByJobExecutionNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists target executions for all steps of a job execution.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByJobExecutionNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByJobExecutionNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobExecutionNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByStepNext(final String nextPageLink) {
        ServiceResponse<Page<JobExecutionInner>> response = listByStepNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByStepNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByStepNextAsync(final String nextPageLink, final ServiceFuture<List<JobExecutionInner>> serviceFuture, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByStepNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByStepNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByStepNextAsync(final String nextPageLink) {
        return listByStepNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepNextWithServiceResponseAsync(final String nextPageLink) {
        return listByStepNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByStepNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the target executions of a job step execution.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByStepNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByStepNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByStepNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
