/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.ServerKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * The managed instance encryption protector.
 */
@JsonFlatten
public class ManagedInstanceEncryptionProtectorInner extends ProxyResource {
    /**
     * Kind of encryption protector. This is metadata used for the Azure portal
     * experience.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /**
     * The name of the managed instance key.
     */
    @JsonProperty(value = "properties.serverKeyName")
    private String serverKeyName;

    /**
     * The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     * Possible values include: 'ServiceManaged', 'AzureKeyVault'.
     */
    @JsonProperty(value = "properties.serverKeyType", required = true)
    private ServerKeyType serverKeyType;

    /**
     * The URI of the server key.
     */
    @JsonProperty(value = "properties.uri", access = JsonProperty.Access.WRITE_ONLY)
    private String uri;

    /**
     * Thumbprint of the server key.
     */
    @JsonProperty(value = "properties.thumbprint", access = JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;

    /**
     * Get kind of encryption protector. This is metadata used for the Azure portal experience.
     *
     * @return the kind value
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the name of the managed instance key.
     *
     * @return the serverKeyName value
     */
    public String serverKeyName() {
        return this.serverKeyName;
    }

    /**
     * Set the name of the managed instance key.
     *
     * @param serverKeyName the serverKeyName value to set
     * @return the ManagedInstanceEncryptionProtectorInner object itself.
     */
    public ManagedInstanceEncryptionProtectorInner withServerKeyName(String serverKeyName) {
        this.serverKeyName = serverKeyName;
        return this;
    }

    /**
     * Get the encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'.
     *
     * @return the serverKeyType value
     */
    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    /**
     * Set the encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'.
     *
     * @param serverKeyType the serverKeyType value to set
     * @return the ManagedInstanceEncryptionProtectorInner object itself.
     */
    public ManagedInstanceEncryptionProtectorInner withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    /**
     * Get the URI of the server key.
     *
     * @return the uri value
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Get thumbprint of the server key.
     *
     * @return the thumbprint value
     */
    public String thumbprint() {
        return this.thumbprint;
    }

}
