/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ManagedInstanceKeys.
 */
public class ManagedInstanceKeysInner {
    /** The Retrofit service to perform REST calls. */
    private ManagedInstanceKeysService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of ManagedInstanceKeysInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ManagedInstanceKeysInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(ManagedInstanceKeysService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ManagedInstanceKeys to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ManagedInstanceKeysService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys listByInstance" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys")
        Observable<Response<ResponseBody>> listByInstance(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("keyName") String keyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("keyName") String keyName, @Path("subscriptionId") String subscriptionId, @Body ManagedInstanceKeyInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("keyName") String keyName, @Path("subscriptionId") String subscriptionId, @Body ManagedInstanceKeyInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("keyName") String keyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("keyName") String keyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys listByInstanceNext" })
        @GET
        Observable<Response<ResponseBody>> listByInstanceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedInstanceKeyInner&gt; object if successful.
     */
    public PagedList<ManagedInstanceKeyInner> listByInstance(final String resourceGroupName, final String managedInstanceName) {
        ServiceResponse<Page<ManagedInstanceKeyInner>> response = listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedInstanceKeyInner>(response.body()) {
            @Override
            public Page<ManagedInstanceKeyInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedInstanceKeyInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName, final ListOperationCallback<ManagedInstanceKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName),
            new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceKeyInner&gt; object
     */
    public Observable<Page<ManagedInstanceKeyInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName)
            .map(new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Page<ManagedInstanceKeyInner>>() {
                @Override
                public Page<ManagedInstanceKeyInner> call(ServiceResponse<Page<ManagedInstanceKeyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceKeyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName)
            .concatMap(new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(ServiceResponse<Page<ManagedInstanceKeyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedInstanceKeyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceSinglePageAsync(final String resourceGroupName, final String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        final String filter = null;
        return service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> result = listByInstanceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedInstanceKeyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param filter An OData filter expression that filters elements in the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedInstanceKeyInner&gt; object if successful.
     */
    public PagedList<ManagedInstanceKeyInner> listByInstance(final String resourceGroupName, final String managedInstanceName, final String filter) {
        ServiceResponse<Page<ManagedInstanceKeyInner>> response = listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, filter).toBlocking().single();
        return new PagedList<ManagedInstanceKeyInner>(response.body()) {
            @Override
            public Page<ManagedInstanceKeyInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param filter An OData filter expression that filters elements in the collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedInstanceKeyInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName, final String filter, final ListOperationCallback<ManagedInstanceKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, filter),
            new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param filter An OData filter expression that filters elements in the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceKeyInner&gt; object
     */
    public Observable<Page<ManagedInstanceKeyInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName, final String filter) {
        return listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName, filter)
            .map(new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Page<ManagedInstanceKeyInner>>() {
                @Override
                public Page<ManagedInstanceKeyInner> call(ServiceResponse<Page<ManagedInstanceKeyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param filter An OData filter expression that filters elements in the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceKeyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName, final String filter) {
        return listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, filter)
            .concatMap(new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(ServiceResponse<Page<ManagedInstanceKeyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
    ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> * @param managedInstanceName The name of the managed instance.
    ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> * @param filter An OData filter expression that filters elements in the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedInstanceKeyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceSinglePageAsync(final String resourceGroupName, final String managedInstanceName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> result = listByInstanceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedInstanceKeyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ManagedInstanceKeyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ManagedInstanceKeyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedInstanceKeyInner object if successful.
     */
    public ManagedInstanceKeyInner get(String resourceGroupName, String managedInstanceName, String keyName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).toBlocking().single().body();
    }

    /**
     * Gets a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedInstanceKeyInner> getAsync(String resourceGroupName, String managedInstanceName, String keyName, final ServiceCallback<ManagedInstanceKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName), serviceCallback);
    }

    /**
     * Gets a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceKeyInner object
     */
    public Observable<ManagedInstanceKeyInner> getAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).map(new Func1<ServiceResponse<ManagedInstanceKeyInner>, ManagedInstanceKeyInner>() {
            @Override
            public ManagedInstanceKeyInner call(ServiceResponse<ManagedInstanceKeyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceKeyInner object
     */
    public Observable<ServiceResponse<ManagedInstanceKeyInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.get(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceKeyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedInstanceKeyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedInstanceKeyInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedInstanceKeyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedInstanceKeyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedInstanceKeyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedInstanceKeyInner object if successful.
     */
    public ManagedInstanceKeyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedInstanceKeyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters, final ServiceCallback<ManagedInstanceKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ManagedInstanceKeyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).map(new Func1<ServiceResponse<ManagedInstanceKeyInner>, ManagedInstanceKeyInner>() {
            @Override
            public ManagedInstanceKeyInner call(ServiceResponse<ManagedInstanceKeyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ManagedInstanceKeyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedInstanceKeyInner>() { }.getType());
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedInstanceKeyInner object if successful.
     */
    public ManagedInstanceKeyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedInstanceKeyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters, final ServiceCallback<ManagedInstanceKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceKeyInner object
     */
    public Observable<ManagedInstanceKeyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).map(new Func1<ServiceResponse<ManagedInstanceKeyInner>, ManagedInstanceKeyInner>() {
            @Override
            public ManagedInstanceKeyInner call(ServiceResponse<ManagedInstanceKeyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a managed instance key.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be operated on (updated or created).
     * @param parameters The requested managed instance key resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceKeyInner object
     */
    public Observable<ServiceResponse<ManagedInstanceKeyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-10-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceKeyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedInstanceKeyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedInstanceKeyInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedInstanceKeyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedInstanceKeyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedInstanceKeyInner>() { }.getType())
                .register(201, new TypeToken<ManagedInstanceKeyInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String managedInstanceName, String keyName) {
        deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).toBlocking().last().body();
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String keyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName), serviceCallback);
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        return deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String managedInstanceName, String keyName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).toBlocking().single().body();
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String keyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName), serviceCallback);
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the managed instance key with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param keyName The name of the managed instance key to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.beginDelete(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedInstanceKeyInner&gt; object if successful.
     */
    public PagedList<ManagedInstanceKeyInner> listByInstanceNext(final String nextPageLink) {
        ServiceResponse<Page<ManagedInstanceKeyInner>> response = listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceKeyInner>(response.body()) {
            @Override
            public Page<ManagedInstanceKeyInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedInstanceKeyInner>> listByInstanceNextAsync(final String nextPageLink, final ServiceFuture<List<ManagedInstanceKeyInner>> serviceFuture, final ListOperationCallback<ManagedInstanceKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceKeyInner&gt; object
     */
    public Observable<Page<ManagedInstanceKeyInner>> listByInstanceNextAsync(final String nextPageLink) {
        return listByInstanceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Page<ManagedInstanceKeyInner>>() {
                @Override
                public Page<ManagedInstanceKeyInner> call(ServiceResponse<Page<ManagedInstanceKeyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceKeyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceNextWithServiceResponseAsync(final String nextPageLink) {
        return listByInstanceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(ServiceResponse<Page<ManagedInstanceKeyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of managed instance keys.
     *
    ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedInstanceKeyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> result = listByInstanceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedInstanceKeyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ManagedInstanceKeyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ManagedInstanceKeyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
