/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RecoverableManagedDatabases.
 */
public class RecoverableManagedDatabasesInner {
    /** The Retrofit service to perform REST calls. */
    private RecoverableManagedDatabasesService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of RecoverableManagedDatabasesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RecoverableManagedDatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(RecoverableManagedDatabasesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RecoverableManagedDatabases to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RecoverableManagedDatabasesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RecoverableManagedDatabases listByInstance" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/recoverableDatabases")
        Observable<Response<ResponseBody>> listByInstance(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RecoverableManagedDatabases get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/recoverableDatabases/{recoverableDatabaseName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("recoverableDatabaseName") String recoverableDatabaseName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RecoverableManagedDatabases listByInstanceNext" })
        @GET
        Observable<Response<ResponseBody>> listByInstanceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecoverableManagedDatabaseInner&gt; object if successful.
     */
    public PagedList<RecoverableManagedDatabaseInner> listByInstance(final String resourceGroupName, final String managedInstanceName) {
        ServiceResponse<Page<RecoverableManagedDatabaseInner>> response = listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<RecoverableManagedDatabaseInner>(response.body()) {
            @Override
            public Page<RecoverableManagedDatabaseInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecoverableManagedDatabaseInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName, final ListOperationCallback<RecoverableManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName),
            new Func1<String, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecoverableManagedDatabaseInner&gt; object
     */
    public Observable<Page<RecoverableManagedDatabaseInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName)
            .map(new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Page<RecoverableManagedDatabaseInner>>() {
                @Override
                public Page<RecoverableManagedDatabaseInner> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecoverableManagedDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName)
            .concatMap(new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of recoverable managed databases.
     *
    ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecoverableManagedDatabaseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceSinglePageAsync(final String resourceGroupName, final String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> result = listByInstanceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecoverableManagedDatabaseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<RecoverableManagedDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<RecoverableManagedDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a recoverable managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param recoverableDatabaseName the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RecoverableManagedDatabaseInner object if successful.
     */
    public RecoverableManagedDatabaseInner get(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, recoverableDatabaseName).toBlocking().single().body();
    }

    /**
     * Gets a recoverable managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param recoverableDatabaseName the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RecoverableManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName, final ServiceCallback<RecoverableManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, managedInstanceName, recoverableDatabaseName), serviceCallback);
    }

    /**
     * Gets a recoverable managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param recoverableDatabaseName the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecoverableManagedDatabaseInner object
     */
    public Observable<RecoverableManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, recoverableDatabaseName).map(new Func1<ServiceResponse<RecoverableManagedDatabaseInner>, RecoverableManagedDatabaseInner>() {
            @Override
            public RecoverableManagedDatabaseInner call(ServiceResponse<RecoverableManagedDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a recoverable managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param recoverableDatabaseName the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecoverableManagedDatabaseInner object
     */
    public Observable<ServiceResponse<RecoverableManagedDatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (recoverableDatabaseName == null) {
            throw new IllegalArgumentException("Parameter recoverableDatabaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.get(resourceGroupName, managedInstanceName, recoverableDatabaseName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecoverableManagedDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<RecoverableManagedDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RecoverableManagedDatabaseInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RecoverableManagedDatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RecoverableManagedDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RecoverableManagedDatabaseInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecoverableManagedDatabaseInner&gt; object if successful.
     */
    public PagedList<RecoverableManagedDatabaseInner> listByInstanceNext(final String nextPageLink) {
        ServiceResponse<Page<RecoverableManagedDatabaseInner>> response = listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecoverableManagedDatabaseInner>(response.body()) {
            @Override
            public Page<RecoverableManagedDatabaseInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecoverableManagedDatabaseInner>> listByInstanceNextAsync(final String nextPageLink, final ServiceFuture<List<RecoverableManagedDatabaseInner>> serviceFuture, final ListOperationCallback<RecoverableManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecoverableManagedDatabaseInner&gt; object
     */
    public Observable<Page<RecoverableManagedDatabaseInner>> listByInstanceNextAsync(final String nextPageLink) {
        return listByInstanceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Page<RecoverableManagedDatabaseInner>>() {
                @Override
                public Page<RecoverableManagedDatabaseInner> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of recoverable managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecoverableManagedDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceNextWithServiceResponseAsync(final String nextPageLink) {
        return listByInstanceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of recoverable managed databases.
     *
    ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecoverableManagedDatabaseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> result = listByInstanceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecoverableManagedDatabaseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<RecoverableManagedDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<RecoverableManagedDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
