/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class Driver {
    private static Driver instance;

    public static synchronized Path ensureDriverInstalled() {
        if (instance == null) {
            try {
                instance = Driver.createDriver();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to create driver", exception);
            }
        }
        String name = instance.cliFileName();
        return instance.driverDir().resolve(name);
    }

    protected String cliFileName() {
        return System.getProperty("os.name").toLowerCase().contains("windows") ? "playwright.cmd" : "playwright.sh";
    }

    private static Driver createDriver() throws Exception {
        String pathFromProperty = System.getProperty("playwright.cli.dir");
        if (pathFromProperty != null) {
            return new PreinstalledDriver(Paths.get(pathFromProperty, new String[0]));
        }
        Class<?> jarDriver = Class.forName("com.microsoft.playwright.impl.DriverJar");
        return (Driver)jarDriver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    abstract Path driverDir();

    private static class PreinstalledDriver
    extends Driver {
        private final Path driverDir;

        PreinstalledDriver(Path driverDir) {
            this.driverDir = driverDir;
        }

        @Override
        Path driverDir() {
            return this.driverDir;
        }
    }
}

