/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PackageImportSorter {
    private String[] order = new String[4];

    public PackageImportSorter() {
        this.order[0] = "java";
        this.order[1] = "javax";
        this.order[2] = "org";
        this.order[3] = "com";
    }

    public List sortBlocks(List imports) {
        HashMap groups = new HashMap();
        TreeSet sortedGroups = new TreeSet();
        ArrayList resultList = new ArrayList();
        this.initializeGroups(imports, groups, sortedGroups);
        if (groups.isEmpty()) {
            this.prepareSingleBlock(imports, resultList);
            return resultList;
        }
        this.classifyImports(groups, sortedGroups);
        this.prepareResultList(groups, resultList);
        return resultList;
    }

    private void prepareSingleBlock(List imports, List resultList) {
        TreeSet block = new TreeSet(imports);
        resultList.add(block);
    }

    private List getGroupsAsSortedList() {
        TreeSet<String> allGroupSet = new TreeSet<String>();
        for (int ii = 0; ii < this.order.length; ++ii) {
            allGroupSet.add(this.order[ii]);
        }
        ArrayList allGroups = new ArrayList(allGroupSet);
        Collections.reverse(allGroups);
        return allGroups;
    }

    private void prepareResultList(Map groups, List resultList) {
        for (int ii = 0; ii < this.order.length; ++ii) {
            Group currentGroup = (Group)groups.get(this.order[ii]);
            if (null == currentGroup) continue;
            this.addIfNotEmpty(resultList, currentGroup.getBeforeGroup());
            this.addIfNotEmpty(resultList, currentGroup.getActualGroup());
            this.addIfNotEmpty(resultList, currentGroup.getAfterGroup());
        }
    }

    private void addIfNotEmpty(List list, Set set) {
        if (null == set || set.isEmpty()) {
            return;
        }
        list.add(set);
    }

    private void initializeGroups(List imports, Map groups, Set sortedGroups) {
        List allGroups = this.getGroupsAsSortedList();
        sortedGroups.addAll(imports);
        for (int ii = 0; ii < imports.size(); ++ii) {
            String currentImport = (String)imports.get(ii);
            this.createGroupIfMatching(allGroups, groups, sortedGroups, currentImport);
        }
        sortedGroups.addAll(groups.keySet());
    }

    private void createGroupIfMatching(List allGroups, Map groups, Set sortedGroups, String currentImport) {
        for (int ii = 0; ii < allGroups.size(); ++ii) {
            String groupName = (String)allGroups.get(ii);
            if (!currentImport.startsWith(groupName)) continue;
            Group group = this.getGroupByName(groups, groupName);
            group.addToActualGroup(currentImport);
            sortedGroups.remove(currentImport);
            return;
        }
    }

    private Group getGroupByName(Map groups, String groupName) {
        Group group = (Group)groups.get(groupName);
        if (null == group) {
            group = new Group(groupName);
            groups.put(groupName, group);
        }
        return group;
    }

    private void classifyImports(Map groups, Set sortedGroups) {
        Group currentGroup = null;
        TreeSet tempBeforeGroup = new TreeSet();
        for (String currentImport : sortedGroups) {
            Group tempGroup = (Group)groups.get(currentImport);
            currentGroup = this.handleTempGroup(currentGroup, tempBeforeGroup, currentImport, tempGroup);
        }
    }

    private Group handleTempGroup(Group currentGroup, Set tempBeforeGroup, String currentImport, Group tempGroup) {
        if (null != tempGroup) {
            if (null == currentGroup) {
                tempGroup.addAllToBeforeGroup(tempBeforeGroup);
            }
            currentGroup = tempGroup;
        } else if (null == currentGroup) {
            tempBeforeGroup.add(currentImport);
        } else {
            currentGroup.addToAfterGroup(currentImport);
        }
        return currentGroup;
    }

    private class Group {
        private String groupName;
        private Set beforeGroup;
        private Set actualGroup;
        private Set afterGroup;

        public Group(String groupName) {
            this.groupName = groupName;
            this.beforeGroup = new TreeSet();
            this.actualGroup = new TreeSet();
            this.afterGroup = new TreeSet();
        }

        public String getGroupName() {
            return this.groupName;
        }

        public Set getActualGroup() {
            return this.actualGroup;
        }

        public Set getAfterGroup() {
            return this.afterGroup;
        }

        public Set getBeforeGroup() {
            return this.beforeGroup;
        }

        public void addAllToBeforeGroup(Set importSet) {
            this.beforeGroup.addAll(importSet);
        }

        public void addAllToActualGroup(Set importSet) {
            this.actualGroup.addAll(importSet);
        }

        public void addAllToAfterGroup(Set importSet) {
            this.afterGroup.addAll(importSet);
        }

        public void addToBeforeGroup(String importString) {
            this.beforeGroup.add(importString);
        }

        public void addToActualGroup(String importString) {
            this.actualGroup.add(importString);
        }

        public void addToAfterGroup(String importString) {
            this.afterGroup.add(importString);
        }
    }
}

