/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.mockrunner.gen.proc.JavaLineAssembler;
import java.util.ArrayList;
import junit.framework.TestCase;

public class JavaLineAssemblerTest
extends TestCase {
    private static final String NL = System.getProperty("line.separator");
    private JavaLineAssembler assembler;

    protected void setUp() throws Exception {
        super.setUp();
        this.assembler = new JavaLineAssembler();
    }

    public void testReset() {
        this.assembler.appendLine("xyz");
        this.assembler.reset();
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
    }

    public void testAppendBlankAndNewline() {
        this.assembler.appendBlank(3);
        this.assembler.appendBlank();
        this.assembler.appendNewLine(3);
        this.assembler.appendNewLine();
        JavaLineAssemblerTest.assertEquals((String)("    " + NL + NL + NL + NL), (String)this.assembler.getResult());
    }

    public void testAppendLine() {
        this.assembler.appendLine(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendLine("");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendLine("testLine");
        JavaLineAssemblerTest.assertEquals((String)("testLine" + NL), (String)this.assembler.getResult());
    }

    public void testAppendCodeLines() {
        this.assembler.appendCodeLines(null);
        JavaLineAssemblerTest.assertEquals((String)NL, (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendCodeLines(new String[0]);
        JavaLineAssemblerTest.assertEquals((String)NL, (String)this.assembler.getResult());
        this.assembler.reset();
        String[] lines = new String[]{"Line1", "Line2", "Line3", "Line4", "Line5"};
        this.assembler.appendCodeLines(lines);
        String expected = "Line1" + NL + "Line2" + NL + "Line3" + NL + "Line4" + NL + "Line5" + NL;
        JavaLineAssemblerTest.assertEquals((String)expected, (String)this.assembler.getResult());
    }

    public void testAppendIndent() {
        this.assembler.appendIndent();
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.setIndentLevel(2);
        this.assembler.appendIndent();
        JavaLineAssemblerTest.assertEquals((String)"        ", (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.setIndentLevel(1);
        this.assembler.appendLine("testLine");
        JavaLineAssemblerTest.assertEquals((String)("    testLine" + NL), (String)this.assembler.getResult());
    }

    public void testAppendPackageInfo() {
        this.assembler.appendPackageInfo(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendPackageInfo("");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendPackageInfo("myPackage");
        JavaLineAssemblerTest.assertEquals((String)("package myPackage;" + NL + NL), (String)this.assembler.getResult());
    }

    public void testAppendImports() {
        this.assembler.appendImports(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendImports(new ArrayList());
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendImport("com.MyClass");
        JavaLineAssemblerTest.assertEquals((String)("import com.MyClass;" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("com.MyClass1");
        importList.add("com.MyClass2");
        importList.add("com.MyClass3");
        this.assembler.appendImports(importList);
        JavaLineAssemblerTest.assertEquals((String)("import com.MyClass1;" + NL + "import com.MyClass2;" + NL + "import com.MyClass3;" + NL), (String)this.assembler.getResult());
    }

    public void testAppendClassDefintion() {
        this.assembler.appendClassDefintion(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendClassDefintion("");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendClassDefintion("MyClass");
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", "");
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", new String[0]);
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", "", "", null);
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", "abstract", "", null);
        JavaLineAssemblerTest.assertEquals((String)("public abstract class MyClass" + NL), (String)this.assembler.getResult());
    }

    public void testAppendClassDefintionWithSuperClass() {
        this.assembler.appendClassDefintion(null, "MySuperClass");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendClassDefintion("", "MySuperClass");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendClassDefintion("MyClass", "MySuperClass");
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass extends MySuperClass" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", "", "MySuperClass", null);
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass extends MySuperClass" + NL), (String)this.assembler.getResult());
    }

    public void testAppendClassDefintionWithInterfaces() {
        this.assembler.appendClassDefintion(null, new String[]{"1"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendClassDefintion("", new String[]{"1"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendClassDefintion("MyClass", new String[]{"1"});
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass implements 1" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", new String[]{"Interface1", "Interface2", "Interface3"});
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass implements Interface1, Interface2, Interface3" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendClassDefintion("MyClass", "", "", new String[]{"1", "2"});
        JavaLineAssemblerTest.assertEquals((String)("public class MyClass implements 1, 2" + NL), (String)this.assembler.getResult());
    }

    public void testAppendClassDefintionWithSuperClassAndInterfaces() {
        this.assembler.setIndentLevel(2);
        this.assembler.appendClassDefintion("MyClass", "", "MySuperClass", new String[]{"1", "2"});
        JavaLineAssemblerTest.assertEquals((String)("        public class MyClass extends MySuperClass implements 1, 2" + NL), (String)this.assembler.getResult());
    }

    public void testAppendMemberDeclaration() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendMemberDeclaration("", "myName");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMemberDeclaration("MyType", null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMemberDeclaration("MyType", "myName");
        JavaLineAssemblerTest.assertEquals((String)("    private MyType myName;" + NL), (String)this.assembler.getResult());
    }

    public void testAppendMethodDeclaration() {
        this.assembler.setIndentLevel(2);
        this.assembler.appendMethodDeclaration("");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMethodDeclaration(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMethodDeclaration("myMethod");
        JavaLineAssemblerTest.assertEquals((String)("        void myMethod()" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.setDefaultMethodModifier("protected");
        this.assembler.setIndentLevel(1);
        this.assembler.appendMethodDeclaration("myMethod");
        JavaLineAssemblerTest.assertEquals((String)("    protected void myMethod()" + NL), (String)this.assembler.getResult());
    }

    public void testAppendMethodDeclarationWithReturnType() {
        this.assembler.setIndentLevel(2);
        this.assembler.appendMethodDeclaration("MyReturnType", "");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMethodDeclaration("MyReturnType", null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.setDefaultMethodModifier("private");
        this.assembler.appendMethodDeclaration("", "myMethod");
        JavaLineAssemblerTest.assertEquals((String)("        private void myMethod()" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.setDefaultMethodModifier("");
        this.assembler.setIndentLevel(0);
        this.assembler.appendMethodDeclaration("MyReturnType", "myMethod");
        JavaLineAssemblerTest.assertEquals((String)("MyReturnType myMethod()" + NL), (String)this.assembler.getResult());
    }

    public void testAppendMethodDeclarationWithReturnTypeAndParameters() {
        this.assembler.appendMethodDeclaration("MyReturnType", "", new String[]{"1"}, new String[]{"2"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMethodDeclaration("MyReturnType", null, new String[]{"1"}, new String[]{"2"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.setDefaultMethodModifier("public");
        this.assembler.appendMethodDeclaration("", "myMethod", new String[]{"String"}, new String[]{"myString"});
        JavaLineAssemblerTest.assertEquals((String)("public void myMethod(String myString)" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.setIndentLevel(1);
        String[] types = new String[]{"String", "int", "Integer", "double"};
        this.assembler.appendMethodDeclaration("MyReturnType", "myMethod", types, null);
        JavaLineAssemblerTest.assertEquals((String)("    MyReturnType myMethod(String param0, int param1, Integer param2, double param3)" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        String[] names = new String[]{"string0", "int1", "int2"};
        this.assembler.appendMethodDeclaration("MyReturnType", "myMethod", types, names);
        JavaLineAssemblerTest.assertEquals((String)("MyReturnType myMethod(String string0, int int1, Integer int2, double param3)" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.setDefaultMethodModifier("protected");
        names = new String[]{"string0", "int1", "int2", "double3"};
        this.assembler.appendMethodDeclaration("MyReturnType", "myMethod", types, names);
        JavaLineAssemblerTest.assertEquals((String)("protected MyReturnType myMethod(String string0, int int1, Integer int2, double double3)" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.setDefaultMethodModifier("private");
        names = new String[]{"string0", "int1", "int2", "double3", "xyz"};
        this.assembler.appendMethodDeclaration("MyReturnType", "myMethod", types, names);
        JavaLineAssemblerTest.assertEquals((String)("private MyReturnType myMethod(String string0, int int1, Integer int2, double double3)" + NL), (String)this.assembler.getResult());
    }

    public void testAppendMethodDeclarationWithReturnTypeParametersAndModifiers() {
        this.assembler.appendMethodDeclaration(new String[]{"abstract"}, "MyReturnType", "", new String[]{"1"}, new String[]{"2"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendMethodDeclaration(new String[]{"abstract"}, "MyReturnType", null, new String[]{"1"}, new String[]{"2"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.setDefaultMethodModifier("public");
        this.assembler.appendMethodDeclaration(new String[]{"abstract"}, "", "myMethod", new String[]{"String"}, new String[]{"myString"});
        JavaLineAssemblerTest.assertEquals((String)("public abstract void myMethod(String myString)" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        String[] types = new String[]{"String", "int", "Integer", "double"};
        String[] names = new String[]{"string0", "int1", "int2"};
        String[] modifiers = new String[]{"abstract", "synchronized"};
        this.assembler.appendMethodDeclaration(modifiers, "MyReturnType", "myMethod", types, names);
        JavaLineAssemblerTest.assertEquals((String)("abstract synchronized MyReturnType myMethod(String string0, int int1, Integer int2, double param3)" + NL), (String)this.assembler.getResult());
    }

    public void testAppendMethodDeclarationWithReturnTypeParametersModifiersAndExceptions() {
        this.assembler.setDefaultMethodModifier("public");
        this.assembler.appendMethodDeclaration(new String[]{"abstract"}, "", "myMethod", new String[]{"String"}, new String[]{"myString"}, new String[]{"FirstException", "SecondException"});
        JavaLineAssemblerTest.assertEquals((String)("public abstract void myMethod(String myString) throws FirstException, SecondException" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        String[] types = new String[]{"String", "int", "Integer", "double"};
        String[] names = new String[]{"string0", "int1", "int2"};
        String[] modifiers = new String[]{"abstract", "synchronized"};
        this.assembler.appendMethodDeclaration(modifiers, "MyReturnType", "myMethod", types, names, null);
        JavaLineAssemblerTest.assertEquals((String)("abstract synchronized MyReturnType myMethod(String string0, int int1, Integer int2, double param3)" + NL), (String)this.assembler.getResult());
        this.assembler.reset();
        this.assembler.appendMethodDeclaration(modifiers, null, "myMethod", null, null, new String[]{"Exception"});
        JavaLineAssemblerTest.assertEquals((String)("abstract synchronized void myMethod() throws Exception" + NL), (String)this.assembler.getResult());
    }

    public void testAppendConstructorDeclaration() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendConstructorDeclaration("");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendConstructorDeclaration(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendConstructorDeclaration("MyConstructor");
        JavaLineAssemblerTest.assertEquals((String)("    public MyConstructor()" + NL), (String)this.assembler.getResult());
    }

    public void testAppendConstructorDeclarationWithParameters() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendConstructorDeclaration("", new String[0], new String[0]);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendConstructorDeclaration(null, new String[]{"1"}, new String[]{"2"});
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        String[] types = new String[]{"String", "int", "Integer", "double"};
        String[] names = new String[]{"string0", "int1", "int2"};
        this.assembler.appendConstructorDeclaration("MyConstructor", types, names);
        JavaLineAssemblerTest.assertEquals((String)("    public MyConstructor(String string0, int int1, Integer int2, double param3)" + NL), (String)this.assembler.getResult());
    }

    public void testAppendConstructorDeclarationWithParametersAndExceptions() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendConstructorDeclaration("", new String[0], new String[0], null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        String[] types = new String[]{"String", "int", "Integer", "double"};
        String[] names = new String[]{"string0", "int1", "int2"};
        String[] exceptions = new String[]{"Exception1", "Exception2", "Exception3"};
        this.assembler.appendConstructorDeclaration("MyConstructor", types, names, exceptions);
        JavaLineAssemblerTest.assertEquals((String)("    public MyConstructor(String string0, int int1, Integer int2, double param3) throws Exception1, Exception2, Exception3" + NL), (String)this.assembler.getResult());
    }

    public void testAppendComment() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendComment("");
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendComment(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendComment("this is a comment");
        JavaLineAssemblerTest.assertEquals((String)("    //this is a comment" + NL), (String)this.assembler.getResult());
    }

    public void testAppendBlockComment() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendBlockComment(new String[0]);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendBlockComment(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        String[] lines = new String[]{"This is a", "multiline block", "comment"};
        this.assembler.appendBlockComment(lines);
        String expected = "    /*" + NL + "     * This is a" + NL + "     * multiline block" + NL + "     * comment" + NL + "     */" + NL;
        JavaLineAssemblerTest.assertEquals((String)expected, (String)this.assembler.getResult());
        this.assembler.reset();
        lines = new String[]{"Comment"};
        this.assembler.appendBlockComment(lines);
        expected = "/*" + NL + " * Comment" + NL + " */" + NL;
        JavaLineAssemblerTest.assertEquals((String)expected, (String)this.assembler.getResult());
    }

    public void testAppendJavaDocComment() {
        this.assembler.setIndentLevel(1);
        this.assembler.appendJavaDocComment(new String[0]);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        this.assembler.appendJavaDocComment(null);
        JavaLineAssemblerTest.assertEquals((String)"", (String)this.assembler.getResult());
        String[] lines = new String[]{"This is a", "multiline block", "comment"};
        this.assembler.appendJavaDocComment(lines);
        String expected = "    /**" + NL + "     * This is a" + NL + "     * multiline block" + NL + "     * comment" + NL + "     */" + NL;
        JavaLineAssemblerTest.assertEquals((String)expected, (String)this.assembler.getResult());
    }
}

