/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static List<Byte> getListFromByteArray(byte[] data) {
        ArrayList<Byte> list = new ArrayList<Byte>(data.length);
        for (int ii = 0; ii < data.length; ++ii) {
            list.add(data[ii]);
        }
        return list;
    }

    public static byte[] getByteArrayFromList(List<Byte> data) {
        return ArrayUtil.getByteArrayFromList(data, 0);
    }

    public static byte[] getByteArrayFromList(List<Byte> data, int index) {
        return ArrayUtil.getByteArrayFromList(data, index, data.size() - index);
    }

    public static byte[] getByteArrayFromList(List<Byte> data, int index, int len) {
        if (data.size() == 0) {
            return new byte[0];
        }
        if (index >= data.size()) {
            throw new IndexOutOfBoundsException("Position " + index + " invalid in List of size " + data.size());
        }
        byte[] byteData = new byte[len];
        for (int ii = index; ii < data.size() && ii < index + len; ++ii) {
            Byte nextValue = data.get(ii);
            if (null == nextValue) continue;
            byteData[ii - index] = nextValue;
        }
        return byteData;
    }

    public static void addBytesToList(byte[] data, List<Byte> list, int index) {
        ArrayUtil.addBytesToList(data, 0, data.length, list, index);
    }

    public static void addBytesToList(byte[] data, int offset, int len, List<Byte> list, int index) {
        int ii;
        int bytesToIncrease = index + len - list.size();
        if (bytesToIncrease > 0) {
            for (ii = 0; ii < bytesToIncrease; ++ii) {
                list.add(null);
            }
        }
        for (ii = index; ii < index + len; ++ii) {
            list.set(ii, data[offset + ii - index]);
        }
    }

    public static Object truncateArray(Object sourceArray, int len) {
        return ArrayUtil.truncateArray(sourceArray, 0, len);
    }

    public static Object truncateArray(Object sourceArray, int index, int len) {
        if (!sourceArray.getClass().isArray()) {
            throw new IllegalArgumentException("sourceArray must be an array");
        }
        Object targetArray = Array.newInstance(sourceArray.getClass().getComponentType(), len);
        System.arraycopy(sourceArray, index, targetArray, 0, len);
        return targetArray;
    }

    public static Object copyArray(Object array) {
        if (!array.getClass().isArray()) {
            return array;
        }
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        Object copy = Array.newInstance(componentType, Array.getLength(array));
        for (int ii = 0; ii < length; ++ii) {
            Array.set(copy, ii, Array.get(array, ii));
        }
        return copy;
    }

    public static Object[] convertToObjectArray(Object sourceArray) {
        if (!sourceArray.getClass().isArray()) {
            throw new IllegalArgumentException("sourceArray must be an array");
        }
        Class<Object> componentType = sourceArray.getClass().getComponentType();
        if (!componentType.isPrimitive()) {
            return (Object[])sourceArray;
        }
        if (componentType.equals(Boolean.TYPE)) {
            componentType = Boolean.class;
        } else if (componentType.equals(Byte.TYPE)) {
            componentType = Byte.class;
        } else if (componentType.equals(Character.TYPE)) {
            componentType = Character.class;
        } else if (componentType.equals(Short.TYPE)) {
            componentType = Short.class;
        } else if (componentType.equals(Integer.TYPE)) {
            componentType = Integer.class;
        } else if (componentType.equals(Long.TYPE)) {
            componentType = Long.class;
        } else if (componentType.equals(Float.TYPE)) {
            componentType = Float.class;
        } else if (componentType.equals(Double.TYPE)) {
            componentType = Double.class;
        }
        int length = Array.getLength(sourceArray);
        Object[] targetArray = (Object[])Array.newInstance(componentType, length);
        for (int ii = 0; ii < length; ++ii) {
            targetArray[ii] = Array.get(sourceArray, ii);
        }
        return targetArray;
    }

    public static Object convertToPrimitiveArray(Object[] sourceArray) {
        Class<Object> componentType = sourceArray.getClass().getComponentType();
        if (componentType.equals(Boolean.class)) {
            componentType = Boolean.TYPE;
        } else if (componentType.equals(Byte.class)) {
            componentType = Byte.TYPE;
        } else if (componentType.equals(Character.class)) {
            componentType = Character.TYPE;
        } else if (componentType.equals(Short.class)) {
            componentType = Short.TYPE;
        } else if (componentType.equals(Integer.class)) {
            componentType = Integer.TYPE;
        } else if (componentType.equals(Long.class)) {
            componentType = Long.TYPE;
        } else if (componentType.equals(Float.class)) {
            componentType = Float.TYPE;
        } else if (componentType.equals(Double.class)) {
            componentType = Double.TYPE;
        } else {
            throw new IllegalArgumentException("sourceArray is of type " + componentType + " which is not allowed");
        }
        int length = Array.getLength(sourceArray);
        Object targetArray = Array.newInstance(componentType, length);
        for (int ii = 0; ii < length; ++ii) {
            Array.set(targetArray, ii, Array.get(sourceArray, ii));
        }
        return targetArray;
    }

    public static Object convertToArray(Object object) {
        if (object.getClass().isArray()) {
            return object;
        }
        Object array = Array.newInstance(object.getClass(), 1);
        Array.set(array, 0, object);
        return array;
    }

    public static boolean areArraysEqual(Object array1, Object array2) {
        int length2;
        if (null == array1 && null == array2) {
            return true;
        }
        if (null == array1 || null == array2) {
            return false;
        }
        if (!array1.getClass().isArray() && !array2.getClass().isArray()) {
            return array1.equals(array2);
        }
        if (!array1.getClass().isArray() || !array2.getClass().isArray()) {
            return false;
        }
        int length1 = Array.getLength(array1);
        if (length1 != (length2 = Array.getLength(array2))) {
            return false;
        }
        for (int ii = 0; ii < length1; ++ii) {
            Object value1 = Array.get(array1, ii);
            Object value2 = Array.get(array2, ii);
            if (null != value1 && !value1.equals(value2)) {
                return false;
            }
            if (null != value1 || null == value2) continue;
            return false;
        }
        return true;
    }

    public static int computeHashCode(Object array) {
        if (null == array) {
            return 0;
        }
        if (!array.getClass().isArray()) {
            return array.hashCode();
        }
        int length = Array.getLength(array);
        int hashCode = 17;
        for (int ii = 0; ii < length; ++ii) {
            Object value = Array.get(array, ii);
            if (null == value) continue;
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    public static int indexOf(byte[] source, byte[] bytes) {
        return ArrayUtil.indexOf(source, bytes, 0);
    }

    public static int indexOf(byte[] source, byte[] bytes, int index) {
        if (index + bytes.length > source.length) {
            return -1;
        }
        for (int ii = index; ii <= source.length - bytes.length; ++ii) {
            int yy;
            for (yy = 0; yy < bytes.length && bytes[yy] == source[ii + yy]; ++yy) {
            }
            if (yy != bytes.length) continue;
            return ii;
        }
        return -1;
    }

    public static void ensureUnique(String[] values) {
        Map nameMap = ArrayUtil.collectOccurences(values);
        ArrayUtil.renameDuplicates(values, nameMap);
    }

    private static void renameDuplicates(String[] names, Map nameMap) {
        for (String nextName : nameMap.keySet()) {
            Integer nextValue = (Integer)nameMap.get(nextName);
            if (nextValue <= 1) continue;
            int number = 1;
            for (int ii = 0; ii < names.length; ++ii) {
                if (!names[ii].equals(nextName)) continue;
                names[ii] = nextName + number;
                ++number;
            }
        }
    }

    private static Map collectOccurences(String[] names) {
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        for (int ii = 0; ii < names.length; ++ii) {
            Integer currentValue = (Integer)nameMap.get(names[ii]);
            if (null == currentValue) {
                nameMap.put(names[ii], new Integer(1));
                continue;
            }
            nameMap.put(names[ii], new Integer(currentValue + 1));
        }
        return nameMap;
    }
}

