/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class BeanSerializer
implements Serializer {
    private final String javadocSuffix;

    public BeanSerializer() {
        this(" is a Querydsl bean type");
    }

    public BeanSerializer(String javadocSuffix) {
        this.javadocSuffix = javadocSuffix;
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[importedClasses.size()]));
        writer.javadoc(new String[]{simpleName + this.javadocSuffix});
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.beginClass((Type)model);
        for (Property property : model.getProperties()) {
            for (Annotation annotation : property.getAnnotations()) {
                writer.annotation(annotation);
            }
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + StringUtils.capitalize((String)propertyName), new Parameter[0]);
            writer.line(new String[]{"return ", propertyName, ";"});
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + StringUtils.capitalize((String)propertyName), new Parameter[]{parameter});
            writer.line(new String[]{"this.", propertyName, " = ", propertyName, ";"});
            writer.end();
        }
        writer.end();
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        for (Property property : model.getProperties()) {
            for (Annotation annotation : property.getAnnotations()) {
                imports.add(annotation.annotationType().getName());
            }
        }
        return imports;
    }
}

