/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public class ArrayConstructorExpression<T>
extends ExpressionBase<T[]>
implements FactoryExpression<T[]> {
    private static final long serialVersionUID = 8667880104290226505L;
    private final Class<T> elementType;
    private final List<Expression<?>> args;

    public ArrayConstructorExpression(Expression<?> ... args) {
        this(Object[].class, args);
    }

    public ArrayConstructorExpression(Class<T[]> type, Expression<T> ... args) {
        super(type);
        this.elementType = (Class)Assert.notNull(type.getComponentType(), (String)"componentType");
        this.args = Arrays.asList(args);
    }

    public final Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public T[] newInstance(Object ... a) {
        if (a.getClass().getComponentType().equals(this.elementType)) {
            return a;
        }
        Object[] rv = (Object[])Array.newInstance(this.elementType, a.length);
        System.arraycopy(a, 0, rv, 0, a.length);
        return rv;
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayConstructorExpression) {
            ArrayConstructorExpression c = (ArrayConstructorExpression)obj;
            return ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }
}

