/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Visitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OperationImpl<T>
extends ExpressionBase<T>
implements Operation<T> {
    private static final long serialVersionUID = 4796432056083507588L;
    private final List<Expression<?>> args;
    private final Operator<? super T> operator;

    public static <RT> Operation<RT> create(Class<? extends RT> type, Operator<? super RT> operator, Expression<?> ... args) {
        return new OperationImpl<RT>(type, operator, args);
    }

    public OperationImpl(Class<? extends T> type, Operator<? super T> operator, Expression<?> ... args) {
        this(type, operator, Arrays.asList(args));
    }

    public OperationImpl(Class<? extends T> type, Operator<? super T> operator, List<Expression<?>> args) {
        super(type);
        this.operator = operator;
        this.args = Collections.unmodifiableList(args);
    }

    @Override
    public Expression<?> getArg(int i) {
        return this.args.get(i);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public Operator<? super T> getOperator() {
        return this.operator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Operation) {
            Operation op = (Operation)o;
            return op.getOperator().equals(this.operator) && ((Object)op.getArgs()).equals(this.args) && op.getType().equals(this.type);
        }
        return false;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

