/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.ComparableOperation;

public abstract class ComparableExpression<T extends Comparable>
extends ComparableExpressionBase<T> {
    private static final long serialVersionUID = 5761359576767404270L;

    public ComparableExpression(Class<? extends T> type) {
        super(type);
    }

    @Override
    public ComparableExpression<T> as(Path<T> alias) {
        return ComparableOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public ComparableExpression<T> as(String alias) {
        return this.as((Path)new PathImpl(this.getType(), alias));
    }

    public final BooleanExpression between(T from, T to) {
        return BooleanOperation.create(Ops.BETWEEN, this, new ConstantImpl<T>(from), new ConstantImpl<T>(to));
    }

    public final BooleanExpression between(Expression<T> from, Expression<T> to) {
        return BooleanOperation.create(Ops.BETWEEN, this, from, to);
    }

    public final BooleanExpression notBetween(T from, T to) {
        return this.between(from, to).not();
    }

    public final BooleanExpression notBetween(Expression<T> from, Expression<T> to) {
        return this.between(from, to).not();
    }

    public BooleanExpression gt(T right) {
        return this.gt(new ConstantImpl<T>(right));
    }

    public BooleanExpression gt(Expression<T> right) {
        return BooleanOperation.create(Ops.AFTER, this, right);
    }

    public BooleanExpression goe(T right) {
        return this.goe(new ConstantImpl<T>(right));
    }

    public BooleanExpression goe(Expression<T> right) {
        return BooleanOperation.create(Ops.AOE, this, right);
    }

    public final BooleanExpression lt(T right) {
        return this.lt(new ConstantImpl<T>(right));
    }

    public final BooleanExpression lt(Expression<T> right) {
        return BooleanOperation.create(Ops.BEFORE, this, right);
    }

    public final BooleanExpression loe(T right) {
        return BooleanOperation.create(Ops.BOE, this, new ConstantImpl<T>(right));
    }

    public final BooleanExpression loe(Expression<T> right) {
        return BooleanOperation.create(Ops.BOE, this, right);
    }
}

