/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;

public final class StringExpressions {
    public static StringExpression ltrim(Expression<String> str) {
        return StringOperation.create(Ops.StringOps.LTRIM, str);
    }

    public static StringExpression rtrim(Expression<String> str) {
        return StringOperation.create(Ops.StringOps.RTRIM, str);
    }

    public static StringExpression lpad(Expression<String> in, int length) {
        return StringOperation.create(Ops.StringOps.LPAD, in, ConstantImpl.create(length));
    }

    public static StringExpression lpad(Expression<String> in, Expression<Integer> length) {
        return StringOperation.create(Ops.StringOps.LPAD, in, length);
    }

    public static StringExpression rpad(Expression<String> in, int length) {
        return StringOperation.create(Ops.StringOps.RPAD, in, ConstantImpl.create(length));
    }

    public static StringExpression rpad(Expression<String> in, Expression<Integer> length) {
        return StringOperation.create(Ops.StringOps.RPAD, in, length);
    }

    private StringExpressions() {
    }

    public static StringExpression lpad(Expression<String> in, NumberExpression<Integer> length, char c) {
        return StringOperation.create(Ops.StringOps.LPAD2, in, length, ConstantImpl.create(c));
    }

    public static StringExpression lpad(Expression<String> in, int length, char c) {
        return StringOperation.create(Ops.StringOps.LPAD2, in, ConstantImpl.create(length), ConstantImpl.create(c));
    }

    public static StringExpression rpad(Expression<String> in, NumberExpression<Integer> length, char c) {
        return StringOperation.create(Ops.StringOps.RPAD2, in, length, ConstantImpl.create(c));
    }

    public static StringExpression rpad(Expression<String> in, int length, char c) {
        return StringOperation.create(Ops.StringOps.RPAD2, in, ConstantImpl.create(length), ConstantImpl.create(c));
    }
}

