/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import java.io.IOException;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class StatusFilter
implements Filter {
    private static final int SC_TEMPORARY_REDIRECT = 307;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        InstanceInfo.InstanceStatus status = myInfo.getStatus();
        if (status != InstanceInfo.InstanceStatus.UP && response instanceof HttpServletResponse) {
            HttpServletResponse httpRespone = (HttpServletResponse)response;
            httpRespone.sendError(307, "Current node is currently not ready to serve requests -- current status: " + status + " - try another DS node: ");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

