/*
 * Decompiled with CFR 0.152.
 */
package nebula.test;

import com.energizedwork.spock.extensions.TempDirectory;
import com.google.common.base.Predicate;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import nebula.test.functional.ExecutionResult;
import nebula.test.functional.GradleRunner;
import nebula.test.functional.GradleRunnerFactory;
import nebula.test.functional.PreExecutionAction;
import nebula.test.functional.internal.GradleHandle;
import nebula.test.multiproject.MultiProjectIntegrationHelper;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.LogLevel;
import org.spockframework.runtime.SpockRuntime;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

@SpecMetadata(filename="IntegrationSpec.groovy", line=36)
public abstract class IntegrationSpec
extends Specification
implements GroovyObject {
    private static final String DEFAULT_REMOTE_DEBUG_JVM_ARGUMENTS = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005";
    private static final Integer DEFAULT_DAEMON_MAX_IDLE_TIME_IN_SECONDS_IN_MEMORY_SAFE_MODE;
    @TempDirectory(clean=false)
    @FieldMetadata(name="projectDir", ordinal=0, line=41)
    protected File projectDir;
    @FieldMetadata(name="result", ordinal=1, line=44)
    private ExecutionResult result;
    @FieldMetadata(name="gradleVersion", ordinal=2, line=46)
    protected String gradleVersion;
    @FieldMetadata(name="logLevel", ordinal=3, line=47)
    protected LogLevel logLevel;
    @FieldMetadata(name="moduleName", ordinal=4, line=49)
    protected String moduleName;
    @FieldMetadata(name="settingsFile", ordinal=5, line=50)
    protected File settingsFile;
    @FieldMetadata(name="buildFile", ordinal=6, line=51)
    protected File buildFile;
    @FieldMetadata(name="fork", ordinal=7, line=52)
    protected boolean fork;
    @FieldMetadata(name="remoteDebug", ordinal=8, line=53)
    protected boolean remoteDebug;
    @FieldMetadata(name="jvmArguments", ordinal=9, line=54)
    protected List<String> jvmArguments;
    @FieldMetadata(name="helper", ordinal=10, line=55)
    protected MultiProjectIntegrationHelper helper;
    @FieldMetadata(name="classpathFilter", ordinal=11, line=56)
    protected Predicate<URL> classpathFilter;
    @FieldMetadata(name="initScripts", ordinal=12, line=57)
    protected List<File> initScripts;
    @FieldMetadata(name="preExecutionActions", ordinal=13, line=58)
    protected List<PreExecutionAction> preExecutionActions;
    @FieldMetadata(name="memorySafeMode", ordinal=14, line=60)
    protected boolean memorySafeMode;
    @FieldMetadata(name="daemonMaxIdleTimeInSecondsInMemorySafeMode", ordinal=15, line=61)
    protected Integer daemonMaxIdleTimeInSecondsInMemorySafeMode;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    @FieldMetadata(name="metaClass", ordinal=16, line=-1)
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    private String findModuleName() {
        return this.getProjectDir().getName().replaceAll("_\\d+", "");
    }

    private Object setup() {
        MultiProjectIntegrationHelper multiProjectIntegrationHelper;
        String string;
        this.moduleName = string = this.findModuleName();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.settingsFile)) {
            File file;
            this.settingsFile = file = new File(this.getProjectDir(), "settings.gradle");
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.moduleName}, new String[]{"rootProject.name='", "'\n"});
            ScriptBytecodeAdapter.setProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl), null, (Object)this.settingsFile, (String)"text");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.buildFile)) {
            File file;
            this.buildFile = file = new File(this.getProjectDir(), "build.gradle");
        }
        DefaultGroovyMethods.println((Object)((Object)this), (Object)new GStringImpl(new Object[]{this.getProjectDir()}, new String[]{"Running test from ", ""}));
        ResourceGroovyMethods.leftShift((File)this.buildFile, (Object)new GStringImpl(new Object[]{this.moduleName}, new String[]{"// Running test for ", "\n"}));
        this.helper = multiProjectIntegrationHelper = new MultiProjectIntegrationHelper(this.getProjectDir(), this.settingsFile);
        return multiProjectIntegrationHelper;
    }

    protected GradleHandle launcher(String ... args) {
        List<String> arguments = this.calculateArguments(args);
        List<String> jvmArguments = this.calculateJvmArguments();
        Integer daemonMaxIdleTimeInSeconds = this.calculateMaxIdleDaemonTimeoutInSeconds();
        GradleRunner runner = GradleRunnerFactory.createTooling(this.fork, this.gradleVersion, daemonMaxIdleTimeInSeconds, this.classpathFilter);
        return runner.handle(this.getProjectDir(), arguments, jvmArguments, this.preExecutionActions);
    }

    private List<String> calculateArguments(String ... args) {
        List list;
        List arguments = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        LogLevel logLevel = this.getLogLevel();
        if (ScriptBytecodeAdapter.isCase((Object)logLevel, (Object)LogLevel.INFO)) {
            List list2;
            arguments = list2 = DefaultGroovyMethods.plus((List)arguments, (Object)"--info");
        } else if (ScriptBytecodeAdapter.isCase((Object)logLevel, (Object)LogLevel.DEBUG)) {
            List list3;
            arguments = list3 = DefaultGroovyMethods.plus((List)arguments, (Object)"--debug");
        }
        arguments = list = DefaultGroovyMethods.plus((List)arguments, (Object)"--stacktrace");
        DefaultGroovyMethods.addAll((Collection)arguments, (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)));
        public class _calculateArguments_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateArguments_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object file) {
                return StringGroovyMethods.plus((String)"-I", (CharSequence)((File)file).getAbsolutePath());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateArguments_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        arguments.addAll(DefaultGroovyMethods.collect(this.initScripts, (Closure)new _calculateArguments_closure1((Object)this, (Object)this)));
        return arguments;
    }

    private List<String> calculateJvmArguments() {
        return DefaultGroovyMethods.plus(this.jvmArguments, (Collection)(this.remoteDebug ? ScriptBytecodeAdapter.createList((Object[])new Object[]{DEFAULT_REMOTE_DEBUG_JVM_ARGUMENTS}) : ScriptBytecodeAdapter.createList((Object[])new Object[0])));
    }

    private Integer calculateMaxIdleDaemonTimeoutInSeconds() {
        return (Integer)ScriptBytecodeAdapter.castToType((Object)(this.memorySafeMode ? this.daemonMaxIdleTimeInSecondsInMemorySafeMode : null), Integer.class);
    }

    protected void addInitScript(File initFile) {
        this.initScripts.add(initFile);
    }

    protected void addPreExecute(PreExecutionAction preExecutionAction) {
        this.preExecutionActions.add(preExecutionAction);
    }

    protected LogLevel getLogLevel() {
        return this.logLevel;
    }

    protected File directory(String path, File baseDir) {
        public class _directory_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _directory_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                ((File)this.getDelegate()).mkdirs();
                return it;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _directory_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (File)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)new File(baseDir, path), (Closure)new _directory_closure2((Object)this, (Object)this)), File.class);
    }

    protected File file(String path, File baseDir) {
        Object[] splitted = path.split("/");
        File directory = DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)splitted, Object[].class))) > 1 ? this.directory(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.getAt((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)splitted, Object[].class)), (IntRange)new IntRange(true, 0, Integer.valueOf(-2).intValue())), (String)"/"), baseDir) : baseDir;
        File file = new File(directory, ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])splitted, (int)-1)));
        file.createNewFile();
        return file;
    }

    protected File createFile(String path, File baseDir) {
        CallSite[] callSiteArray = IntegrationSpec.$getCallSiteArray();
        Object $spock_valueRecorder = callSiteArray[0].callConstructor(ValueRecorder.class);
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callCurrent((GroovyObject)this, (Object)path, (Object)baseDir), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)file))) {
            SpockRuntime.verifyCondition((ValueRecorder)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).reset(), (String)"file.parentFile.mkdirs() || file.parentFile.exists()", (int)162, (int)20, null, (Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(10).intValue(), (Object)(DefaultTypeTransformation.booleanUnbox((Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(4).intValue(), ScriptBytecodeAdapter.invokeMethod0(IntegrationSpec.class, (Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(1).intValue(), callSiteArray[3].callGetProperty(((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(0).intValue(), (Object)file))), (String)ShortTypeHandling.castToString((Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(2).intValue(), (Object)"mkdirs"))))) || DefaultTypeTransformation.booleanUnbox((Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(9).intValue(), ScriptBytecodeAdapter.invokeMethod0(IntegrationSpec.class, (Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(6).intValue(), callSiteArray[4].callGetProperty(((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(5).intValue(), (Object)file))), (String)ShortTypeHandling.castToString((Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(7).intValue(), (Object)"exists"))))) ? 1 : 0)));
            callSiteArray[5].call((Object)file);
        }
        return file;
    }

    protected void writeHelloWorld(String packageDotted, File baseDir) {
        String path = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"src/main/java/", (CharSequence)packageDotted.replace(".", "/")), (CharSequence)"/HelloWorld.java");
        File javaFile = this.createFile(path, baseDir);
        ResourceGroovyMethods.leftShift((File)javaFile, (Object)StringGroovyMethods.stripIndent((CharSequence)new GStringImpl(new Object[]{packageDotted}, new String[]{"package ", ";\n\n            public class HelloWorld {\n                public static void main(String[] args) {\n                    System.out.println(\"Hello Integration Test\");\n                }\n            }\n        "})));
    }

    protected void writeUnitTest(boolean failTest, File baseDir) {
        this.writeTest("src/test/java/", "nebula", failTest, baseDir);
    }

    protected void writeTest(String srcDir, String packageDotted, boolean failTest, File baseDir) {
        String path = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)srcDir, (CharSequence)packageDotted.replace(".", "/")), (CharSequence)"/HelloWorldTest.java");
        File javaFile = this.createFile(path, baseDir);
        ResourceGroovyMethods.leftShift((File)javaFile, (Object)StringGroovyMethods.stripIndent((CharSequence)new GStringImpl(new Object[]{packageDotted, failTest}, new String[]{"package ", ";\n            import org.junit.Test;\n            import static org.junit.Assert.assertFalse;\n\n            public class HelloWorldTest {\n                @Test public void doesSomething() {\n                    assertFalse( ", " ); \n                }\n            }\n        "})));
    }

    protected void writeResource(String srcDir, String fileName, File baseDir) {
        GStringImpl path = new GStringImpl(new Object[]{srcDir, fileName}, new String[]{"", "/", ".properties"});
        File resourceFile = this.createFile(ShortTypeHandling.castToString((Object)path), baseDir);
        String string = "firstProperty=foo.bar";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)resourceFile, (String)"text");
    }

    protected void copyResources(String srcDir, String destination) {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL resource = classLoader.getResource(srcDir);
        if (resource == null) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{srcDir}, new String[]{"Could not find classpath resource: ", ""})));
        }
        File destinationFile = this.file(destination);
        File resourceFile = new File(resource.toURI());
        if (resourceFile.isFile()) {
            FileUtils.copyFile((File)resourceFile, (File)destinationFile);
        } else {
            FileUtils.copyDirectory((File)resourceFile, (File)destinationFile);
        }
    }

    protected String applyPlugin(Class pluginClass) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginClass.getName()}, new String[]{"apply plugin: ", ""}));
    }

    protected boolean fileExists(String path) {
        return new File(this.projectDir, path).exists();
    }

    @Deprecated
    protected boolean wasExecuted(String taskPath) {
        return this.result.wasExecuted(taskPath);
    }

    @Deprecated
    protected boolean wasUpToDate(String taskPath) {
        return this.result.wasUpToDate(taskPath);
    }

    @Deprecated
    protected String getStandardError() {
        return this.result.getStandardError();
    }

    @Deprecated
    protected String getStandardOutput() {
        return this.result.getStandardOutput();
    }

    protected ExecutionResult runTasksSuccessfully(String ... tasks) {
        ExecutionResult result = this.runTasks(tasks);
        if (DefaultTypeTransformation.booleanUnbox((Object)result.getFailure())) {
            result.rethrowFailure();
        }
        return result;
    }

    protected ExecutionResult runTasksWithFailure(String ... tasks) {
        CallSite[] callSiteArray = IntegrationSpec.$getCallSiteArray();
        Object $spock_valueRecorder = callSiteArray[6].callConstructor(ValueRecorder.class);
        ExecutionResult result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[7].callCurrent((GroovyObject)this, (Object)tasks);
            result = (ExecutionResult)ScriptBytecodeAdapter.castToType((Object)object, ExecutionResult.class);
        } else {
            ExecutionResult executionResult;
            result = executionResult = this.runTasks(tasks);
        }
        SpockRuntime.verifyCondition((ValueRecorder)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).reset(), (String)"result.failure", (int)282, (int)16, null, (Object)((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(1).intValue(), callSiteArray[8].callGetProperty(((ValueRecorder)ScriptBytecodeAdapter.castToType((Object)$spock_valueRecorder, ValueRecorder.class)).record(Integer.valueOf(0).intValue(), (Object)result))));
        return result;
    }

    protected ExecutionResult runTasks(String ... tasks) {
        ExecutionResult executionResult;
        ExecutionResult result = this.launcher(tasks).run();
        this.result = executionResult = result;
        return result;
    }

    protected File addSubproject(String subprojectName) {
        return this.helper.addSubproject(subprojectName);
    }

    protected File addSubproject(String subprojectName, String subBuildGradleText) {
        return this.helper.addSubproject(subprojectName, subBuildGradleText);
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != IntegrationSpec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private /* synthetic */ Object $spock_initializeFields() {
        MetaClass metaClass;
        Integer n;
        boolean bl;
        List list;
        List list2;
        List list3;
        boolean bl2;
        boolean bl3;
        LogLevel logLevel;
        this.logLevel = logLevel = LogLevel.INFO;
        this.fork = bl3 = false;
        this.remoteDebug = bl2 = false;
        this.jvmArguments = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.initScripts = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.preExecutionActions = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.memorySafeMode = bl = false;
        this.daemonMaxIdleTimeInSecondsInMemorySafeMode = n = DEFAULT_DAEMON_MAX_IDLE_TIME_IN_SECONDS_IN_MEMORY_SAFE_MODE;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        return metaClass;
    }

    protected File directory(String path) {
        return this.directory(path, this.getProjectDir());
    }

    protected File file(String path) {
        return this.file(path, this.getProjectDir());
    }

    protected File createFile(String path) {
        return this.createFile(path, this.getProjectDir());
    }

    protected void writeHelloWorld(String packageDotted) {
        this.writeHelloWorld(packageDotted, this.getProjectDir());
    }

    protected void writeUnitTest(boolean failTest) {
        this.writeUnitTest(failTest, this.getProjectDir());
    }

    protected void writeTest(String srcDir, String packageDotted, boolean failTest) {
        this.writeTest(srcDir, packageDotted, failTest, this.getProjectDir());
    }

    protected void writeResource(String srcDir, String fileName) {
        this.writeResource(srcDir, fileName, this.getProjectDir());
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        int n = 15;
        DEFAULT_DAEMON_MAX_IDLE_TIME_IN_SECONDS_IN_MEMORY_SAFE_MODE = n;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "file";
        stringArray[2] = "exists";
        stringArray[3] = "parentFile";
        stringArray[4] = "parentFile";
        stringArray[5] = "createNewFile";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "runTasks";
        stringArray[8] = "failure";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[9];
        IntegrationSpec.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(IntegrationSpec.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = IntegrationSpec.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

