/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import java.util.ArrayList;
import java.util.Collection;

class CompositeMeter
implements Meter {
    protected final Id id;
    protected final Collection<Registry> registries;

    public CompositeMeter(Id id, Collection<Registry> registries) {
        this.id = id;
        this.registries = registries;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        for (Registry r : this.registries) {
            Meter m = r.get(this.id);
            if (m.hasExpired()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Registry r : this.registries) {
            Meter m = r.get(this.id);
            if (m == null) continue;
            for (Measurement measurement : m.measure()) {
                ms.add(measurement);
            }
        }
        return ms;
    }
}

