/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly.websocket;

import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import com.ning.http.client.ws.WebSocketByteListener;
import com.ning.http.client.ws.WebSocketCloseCodeReasonListener;
import com.ning.http.client.ws.WebSocketPingListener;
import com.ning.http.client.ws.WebSocketPongListener;
import com.ning.http.client.ws.WebSocketTextListener;
import java.io.ByteArrayOutputStream;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketListener;

final class AHCWebSocketListenerAdapter
implements WebSocketListener {
    private final com.ning.http.client.ws.WebSocketListener ahcListener;
    private final GrizzlyWebSocketAdapter webSocket;
    private final StringBuilder stringBuffer;
    private final ByteArrayOutputStream byteArrayOutputStream;

    AHCWebSocketListenerAdapter(com.ning.http.client.ws.WebSocketListener ahcListener, GrizzlyWebSocketAdapter webSocket) {
        this.ahcListener = ahcListener;
        this.webSocket = webSocket;
        if (webSocket.bufferFragments) {
            this.stringBuffer = new StringBuilder();
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        } else {
            this.stringBuffer = null;
            this.byteArrayOutputStream = null;
        }
    }

    public void onClose(WebSocket gWebSocket, DataFrame dataFrame) {
        try {
            if (this.ahcListener instanceof WebSocketCloseCodeReasonListener) {
                ClosingFrame cf = (ClosingFrame)ClosingFrame.class.cast(dataFrame);
                ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(this.ahcListener)).onClose(this.webSocket, cf.getCode(), cf.getReason());
            } else {
                this.ahcListener.onClose(this.webSocket);
            }
        }
        catch (Throwable e) {
            this.ahcListener.onError(e);
        }
    }

    public void onConnect(WebSocket gWebSocket) {
        try {
            this.ahcListener.onOpen(this.webSocket);
        }
        catch (Throwable e) {
            this.ahcListener.onError(e);
        }
    }

    public void onMessage(WebSocket webSocket, String s) {
        try {
            if (this.ahcListener instanceof WebSocketTextListener) {
                ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(s);
            }
        }
        catch (Throwable e) {
            this.ahcListener.onError(e);
        }
    }

    public void onMessage(WebSocket webSocket, byte[] bytes) {
        try {
            if (this.ahcListener instanceof WebSocketByteListener) {
                ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytes);
            }
        }
        catch (Throwable e) {
            this.ahcListener.onError(e);
        }
    }

    public void onPing(WebSocket webSocket, byte[] bytes) {
        try {
            if (this.ahcListener instanceof WebSocketPingListener) {
                ((WebSocketPingListener)WebSocketPingListener.class.cast(this.ahcListener)).onPing(bytes);
            }
        }
        catch (Throwable e) {
            this.ahcListener.onError(e);
        }
    }

    public void onPong(WebSocket webSocket, byte[] bytes) {
        try {
            if (this.ahcListener instanceof WebSocketPongListener) {
                ((WebSocketPongListener)WebSocketPongListener.class.cast(this.ahcListener)).onPong(bytes);
            }
        }
        catch (Throwable e) {
            this.ahcListener.onError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFragment(WebSocket webSocket, String s, boolean last) {
        block6: {
            try {
                if (!this.webSocket.bufferFragments) break block6;
                GrizzlyWebSocketAdapter grizzlyWebSocketAdapter = this.webSocket;
                synchronized (grizzlyWebSocketAdapter) {
                    this.stringBuffer.append(s);
                    if (last && this.ahcListener instanceof WebSocketTextListener) {
                        String message = this.stringBuffer.toString();
                        this.stringBuffer.setLength(0);
                        ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(message);
                    }
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFragment(WebSocket webSocket, byte[] bytes, boolean last) {
        block6: {
            try {
                if (!this.webSocket.bufferFragments) break block6;
                GrizzlyWebSocketAdapter grizzlyWebSocketAdapter = this.webSocket;
                synchronized (grizzlyWebSocketAdapter) {
                    this.byteArrayOutputStream.write(bytes);
                    if (last && this.ahcListener instanceof WebSocketByteListener) {
                        byte[] bytesLocal = this.byteArrayOutputStream.toByteArray();
                        this.byteArrayOutputStream.reset();
                        ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytesLocal);
                    }
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AHCWebSocketListenerAdapter that = (AHCWebSocketListenerAdapter)o;
        if (this.ahcListener != null ? !this.ahcListener.equals(that.ahcListener) : that.ahcListener != null) {
            return false;
        }
        return !(this.webSocket != null ? !this.webSocket.equals(that.webSocket) : that.webSocket != null);
    }

    public int hashCode() {
        int result = this.ahcListener != null ? this.ahcListener.hashCode() : 0;
        result = 31 * result + (this.webSocket != null ? this.webSocket.hashCode() : 0);
        return result;
    }
}

