/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.NotificationManager;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import android.support.annotation.RequiresApi;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import java.util.Map;
import java.util.TreeMap;

class NotificationLimitManager {
    private static final int MAX_NUMBER_OF_NOTIFICATIONS_INT = 49;
    static final String MAX_NUMBER_OF_NOTIFICATIONS_STR = Integer.toString(49);

    NotificationLimitManager() {
    }

    private static int getMaxNumberOfNotificationsInt() {
        return 49;
    }

    private static String getMaxNumberOfNotificationsString() {
        return MAX_NUMBER_OF_NOTIFICATIONS_STR;
    }

    static void clearOldestOverLimit(Context context, int notifsToMakeRoomFor) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                NotificationLimitManager.clearOldestOverLimitStandard(context, notifsToMakeRoomFor);
            } else {
                NotificationLimitManager.clearOldestOverLimitFallback(context, notifsToMakeRoomFor);
            }
        }
        catch (Throwable t) {
            NotificationLimitManager.clearOldestOverLimitFallback(context, notifsToMakeRoomFor);
        }
    }

    @RequiresApi(api=23)
    static void clearOldestOverLimitStandard(Context context, int notifsToMakeRoomFor) throws Throwable {
        NotificationManager notifManager = OneSignalNotificationManager.getNotificationManager(context);
        StatusBarNotification[] activeNotifs = notifManager.getActiveNotifications();
        int notifsToClear = activeNotifs.length - NotificationLimitManager.getMaxNumberOfNotificationsInt() + notifsToMakeRoomFor;
        if (notifsToClear < 1) {
            return;
        }
        TreeMap<Long, Integer> activeNotifIds = new TreeMap<Long, Integer>();
        for (StatusBarNotification activeNotif : activeNotifs) {
            if (NotificationLimitManager.isGroupSummary(activeNotif)) continue;
            activeNotifIds.put(activeNotif.getNotification().when, activeNotif.getId());
        }
        for (Map.Entry entry : activeNotifIds.entrySet()) {
            OneSignal.cancelNotification((Integer)entry.getValue());
            if (--notifsToClear > 0) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearOldestOverLimitFallback(Context context, int notifsToMakeRoomFor) {
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("notification", new String[]{"android_notification_id"}, OneSignalDbHelper.recentUninteractedWithNotificationsWhere().toString(), null, null, null, "_id", NotificationLimitManager.getMaxNumberOfNotificationsString() + notifsToMakeRoomFor);
            int notifsToClear = cursor.getCount() - NotificationLimitManager.getMaxNumberOfNotificationsInt() + notifsToMakeRoomFor;
            if (notifsToClear < 1) {
                return;
            }
            while (cursor.moveToNext()) {
                int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                OneSignal.cancelNotification(existingId);
                if (--notifsToClear > 0) continue;
                break;
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error clearing oldest notifications over limit! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    @RequiresApi(api=21)
    static boolean isGroupSummary(StatusBarNotification notif) {
        return (notif.getNotification().flags & 0x200) != 0;
    }
}

