/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;

class GooglePlayServicesUpgradePrompt {
    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 9000;

    GooglePlayServicesUpgradePrompt() {
    }

    static boolean isGMSInstalledAndEnabled() {
        try {
            PackageManager pm = OneSignal.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.google.android.gms", 128);
            return info.applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static boolean isGooglePlayStoreInstalled() {
        try {
            PackageManager pm = OneSignal.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.google.android.gms", 128);
            String label = (String)info.applicationInfo.loadLabel(pm);
            return label != null && !label.equals("Market");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static void ShowUpdateGPSDialog() {
        if (GooglePlayServicesUpgradePrompt.isGMSInstalledAndEnabled() || !GooglePlayServicesUpgradePrompt.isGooglePlayStoreInstalled()) {
            return;
        }
        boolean userSelectedSkip = OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_DO_NOT_SHOW_MISSING_GPS", false);
        if (userSelectedSkip) {
            return;
        }
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                final Activity activity = ActivityLifecycleHandler.curActivity;
                if (activity == null || OneSignal.mInitBuilder.mDisableGmsMissingPrompt) {
                    return;
                }
                String alertBodyText = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_text", "To receive push notifications please press 'Update' to enable 'Google Play services'.");
                String alertButtonUpdate = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_button_update", "Update");
                String alertButtonSkip = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_button_skip", "Skip");
                String alertButtonClose = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_button_close", "Close");
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                builder.setMessage((CharSequence)alertBodyText).setPositiveButton((CharSequence)alertButtonUpdate, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        GooglePlayServicesUpgradePrompt.OpenPlayStoreToApp(activity);
                    }
                }).setNegativeButton((CharSequence)alertButtonSkip, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_DO_NOT_SHOW_MISSING_GPS", true);
                    }
                }).setNeutralButton((CharSequence)alertButtonClose, null).create().show();
            }
        });
    }

    private static void OpenPlayStoreToApp(Activity activity) {
        try {
            GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
            int resultCode = apiAvailability.isGooglePlayServicesAvailable(OneSignal.appContext);
            apiAvailability.getErrorResolutionPendingIntent((Context)activity, resultCode, 9000).send();
        }
        catch (PendingIntent.CanceledException apiAvailability) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

