/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import com.onesignal.OSInAppMessageDisplayStats;
import com.onesignal.OSTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessage {
    private static final String IAM_ID = "id";
    private static final String IAM_VARIANTS = "variants";
    private static final String IAM_TRIGGERS = "triggers";
    private static final String IAM_RE_DISPLAY = "redisplay";
    private static final String DISPLAY_DURATION = "display_duration";
    @NonNull
    public String messageId;
    @NonNull
    public HashMap<String, HashMap<String, String>> variants;
    @NonNull
    public ArrayList<ArrayList<OSTrigger>> triggers;
    @NonNull
    private Set<String> clickedClickIds;
    private OSInAppMessageDisplayStats displayStats = new OSInAppMessageDisplayStats();
    private double displayDuration;
    private boolean displayedInSession = false;
    private boolean triggerChanged = false;
    private boolean actionTaken;
    boolean isPreview;

    OSInAppMessage(boolean isPreview) {
        this.isPreview = isPreview;
    }

    OSInAppMessage(@NonNull String messageId, @NonNull Set<String> clickIds, boolean displayedInSession, OSInAppMessageDisplayStats displayStats) {
        this.messageId = messageId;
        this.clickedClickIds = clickIds;
        this.displayedInSession = displayedInSession;
        this.displayStats = displayStats;
    }

    OSInAppMessage(JSONObject json) throws JSONException {
        this.messageId = json.getString(IAM_ID);
        this.variants = this.parseVariants(json.getJSONObject(IAM_VARIANTS));
        this.triggers = this.parseTriggerJson(json.getJSONArray(IAM_TRIGGERS));
        this.clickedClickIds = new HashSet<String>();
        if (json.has(IAM_RE_DISPLAY)) {
            this.displayStats = new OSInAppMessageDisplayStats(json.getJSONObject(IAM_RE_DISPLAY));
        }
    }

    private HashMap<String, HashMap<String, String>> parseVariants(JSONObject json) throws JSONException {
        HashMap<String, HashMap<String, String>> variantTypes = new HashMap<String, HashMap<String, String>>();
        Iterator keyIterator = json.keys();
        while (keyIterator.hasNext()) {
            String variantType = (String)keyIterator.next();
            JSONObject variant = json.getJSONObject(variantType);
            HashMap<String, String> variantMap = new HashMap<String, String>();
            Iterator variantIterator = variant.keys();
            while (variantIterator.hasNext()) {
                String languageType = (String)variantIterator.next();
                variantMap.put(languageType, variant.getString(languageType));
            }
            variantTypes.put(variantType, variantMap);
        }
        return variantTypes;
    }

    protected ArrayList<ArrayList<OSTrigger>> parseTriggerJson(JSONArray triggersJson) throws JSONException {
        ArrayList<ArrayList<OSTrigger>> parsedTriggers = new ArrayList<ArrayList<OSTrigger>>();
        for (int i = 0; i < triggersJson.length(); ++i) {
            JSONArray ands = triggersJson.getJSONArray(i);
            ArrayList<OSTrigger> converted = new ArrayList<OSTrigger>();
            for (int j = 0; j < ands.length(); ++j) {
                OSTrigger trigger = new OSTrigger(ands.getJSONObject(j));
                converted.add(trigger);
            }
            parsedTriggers.add(converted);
        }
        return parsedTriggers;
    }

    JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put(IAM_ID, (Object)this.messageId);
            JSONObject variants = new JSONObject();
            for (String key : this.variants.keySet()) {
                HashMap<String, String> variant = this.variants.get(key);
                JSONObject converted = new JSONObject();
                for (String variantKey : variant.keySet()) {
                    converted.put(variantKey, (Object)variant.get(variantKey));
                }
                variants.put(key, (Object)converted);
            }
            json.put(IAM_VARIANTS, (Object)variants);
            json.put(DISPLAY_DURATION, this.displayDuration);
            if (this.displayStats.isRedisplayEnabled()) {
                json.put(IAM_RE_DISPLAY, (Object)this.displayStats.toJSONObject());
            }
            JSONArray orConditions = new JSONArray();
            for (ArrayList<OSTrigger> andArray : this.triggers) {
                JSONArray andConditions = new JSONArray();
                for (OSTrigger trigger : andArray) {
                    andConditions.put((Object)trigger.toJSONObject());
                }
                orConditions.put((Object)andConditions);
            }
            json.put(IAM_TRIGGERS, (Object)orConditions);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json;
    }

    boolean takeActionAsUnique() {
        if (this.actionTaken) {
            return false;
        }
        this.actionTaken = true;
        return true;
    }

    double getDisplayDuration() {
        return this.displayDuration;
    }

    void setDisplayDuration(double displayDuration) {
        this.displayDuration = displayDuration;
    }

    boolean isTriggerChanged() {
        return this.triggerChanged;
    }

    void setTriggerChanged(boolean triggerChanged) {
        this.triggerChanged = triggerChanged;
    }

    public boolean isDisplayedInSession() {
        return this.displayedInSession;
    }

    public void setDisplayedInSession(boolean displayedInSession) {
        this.displayedInSession = displayedInSession;
    }

    @NonNull
    Set<String> getClickedClickIds() {
        return this.clickedClickIds;
    }

    boolean isClickAvailable(String clickId) {
        return !this.clickedClickIds.contains(clickId);
    }

    void clearClickIds() {
        this.clickedClickIds.clear();
    }

    void addClickId(String clickId) {
        this.clickedClickIds.add(clickId);
    }

    OSInAppMessageDisplayStats getDisplayStats() {
        return this.displayStats;
    }

    public String toString() {
        return "OSInAppMessage{messageId='" + this.messageId + '\'' + ", triggers=" + this.triggers + ", clickedClickIds=" + this.clickedClickIds + ", displayStats=" + this.displayStats + ", actionTaken=" + this.actionTaken + ", isPreview=" + this.isPreview + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSInAppMessage that = (OSInAppMessage)o;
        return this.messageId.equals(that.messageId);
    }

    public int hashCode() {
        int result = this.messageId.hashCode();
        return result;
    }
}

