/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.JSONUtils;
import com.onesignal.OneSignal;
import com.onesignal.OutcomesUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSSessionManager {
    private static final String DIRECT_TAG = "direct";
    @NonNull
    protected Session session;
    @Nullable
    private String directNotificationId;
    @Nullable
    private JSONArray indirectNotificationIds;
    @NonNull
    private SessionListener sessionListener;

    public OSSessionManager(@NonNull SessionListener sessionListener) {
        this.sessionListener = sessionListener;
        this.initSessionFromCache();
    }

    private void initSessionFromCache() {
        this.session = OutcomesUtils.getCachedSession();
        if (this.session.isIndirect()) {
            this.indirectNotificationIds = this.getLastNotificationsReceivedIds();
        } else if (this.session.isDirect()) {
            this.directNotificationId = OutcomesUtils.getCachedNotificationOpenId();
        }
    }

    void addSessionNotificationsIds(@NonNull JSONObject jsonObject) {
        if (this.session.isUnattributed()) {
            return;
        }
        try {
            if (this.session.isDirect()) {
                jsonObject.put(DIRECT_TAG, true);
                jsonObject.put("notification_ids", (Object)new JSONArray().put((Object)this.directNotificationId));
            } else if (this.session.isIndirect()) {
                jsonObject.put(DIRECT_TAG, false);
                jsonObject.put("notification_ids", (Object)this.indirectNotificationIds);
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating addNotificationId:JSON Failed.", e);
        }
    }

    void restartSessionIfNeeded() {
        if (OneSignal.getAppEntryState().isNotificationClick()) {
            return;
        }
        JSONArray lastNotifications = this.getLastNotificationsReceivedIds();
        if (lastNotifications.length() > 0) {
            this.setSession(Session.INDIRECT, null, lastNotifications);
        } else {
            this.setSession(Session.UNATTRIBUTED, null, null);
        }
    }

    @NonNull
    Session getSession() {
        return this.session;
    }

    @Nullable
    String getDirectNotificationId() {
        return this.directNotificationId;
    }

    @Nullable
    JSONArray getIndirectNotificationIds() {
        return this.indirectNotificationIds;
    }

    void onDirectSessionFromNotificationOpen(@NonNull String notificationId) {
        this.setSession(Session.DIRECT, notificationId, null);
    }

    private void setSession(@NonNull Session session, @Nullable String directNotificationId, @Nullable JSONArray indirectNotificationIds) {
        if (!this.willChangeSession(session, directNotificationId, indirectNotificationIds)) {
            return;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OSSession changed\nfrom:\nsession: " + (Object)((Object)this.session) + ", directNotificationId: " + this.directNotificationId + ", indirectNotificationIds: " + this.indirectNotificationIds + "\nto:\nsession: " + (Object)((Object)session) + ", directNotificationId: " + directNotificationId + ", indirectNotificationIds: " + indirectNotificationIds);
        OutcomesUtils.cacheCurrentSession(session);
        OutcomesUtils.cacheNotificationOpenId(directNotificationId);
        this.sessionListener.onSessionEnding(this.getSessionResult());
        this.session = session;
        this.directNotificationId = directNotificationId;
        this.indirectNotificationIds = indirectNotificationIds;
    }

    private boolean willChangeSession(@NonNull Session session, @Nullable String directNotificationId, @Nullable JSONArray indirectNotificationIds) {
        if (!session.equals((Object)this.session)) {
            return true;
        }
        if (this.session.isDirect() && this.directNotificationId != null && !this.directNotificationId.equals(directNotificationId)) {
            return true;
        }
        return this.session.isIndirect() && this.indirectNotificationIds != null && this.indirectNotificationIds.length() > 0 && !JSONUtils.compareJSONArrays(this.indirectNotificationIds, indirectNotificationIds);
    }

    @NonNull
    protected JSONArray getLastNotificationsReceivedIds() {
        JSONArray notificationsReceived = OutcomesUtils.getLastNotificationsReceivedData();
        JSONArray notificationsIds = new JSONArray();
        long attributionWindow = (long)(OutcomesUtils.getIndirectAttributionWindow() * 60) * 1000L;
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < notificationsReceived.length(); ++i) {
            try {
                JSONObject jsonObject = notificationsReceived.getJSONObject(i);
                long time = jsonObject.getLong("time");
                long difference = currentTime - time;
                if (difference > attributionWindow) continue;
                String notificationId = jsonObject.getString("notification_id");
                notificationsIds.put((Object)notificationId);
                continue;
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "From getting notification from array:JSON Failed.", e);
            }
        }
        return notificationsIds;
    }

    @NonNull
    SessionResult getSessionResult() {
        if (this.session.isDirect()) {
            if (OutcomesUtils.isDirectSessionEnabled()) {
                JSONArray directNotificationIds = new JSONArray().put((Object)this.directNotificationId);
                return SessionResult.Builder.newInstance().setNotificationIds(directNotificationIds).setSession(Session.DIRECT).build();
            }
        } else if (this.session.isIndirect()) {
            if (OutcomesUtils.isIndirectSessionEnabled()) {
                return SessionResult.Builder.newInstance().setNotificationIds(this.indirectNotificationIds).setSession(Session.INDIRECT).build();
            }
        } else if (OutcomesUtils.isUnattributedSessionEnabled()) {
            return SessionResult.Builder.newInstance().setSession(Session.UNATTRIBUTED).build();
        }
        return SessionResult.Builder.newInstance().setSession(Session.DISABLED).build();
    }

    @NonNull
    SessionResult getIAMSessionResult() {
        if (OutcomesUtils.isUnattributedSessionEnabled()) {
            return SessionResult.Builder.newInstance().setSession(Session.UNATTRIBUTED).build();
        }
        return SessionResult.Builder.newInstance().setSession(Session.DISABLED).build();
    }

    void attemptSessionUpgrade() {
        JSONArray lastNotificationIds;
        if (OneSignal.getAppEntryState().isNotificationClick()) {
            this.setSession(Session.DIRECT, this.directNotificationId, null);
            return;
        }
        if (this.session.isUnattributed() && (lastNotificationIds = this.getLastNotificationsReceivedIds()).length() > 0 && OneSignal.getAppEntryState().isAppOpen()) {
            this.setSession(Session.INDIRECT, null, lastNotificationIds);
        }
    }

    public static enum Session {
        DIRECT,
        INDIRECT,
        UNATTRIBUTED,
        DISABLED;


        public boolean isDirect() {
            return this.equals((Object)DIRECT);
        }

        public boolean isIndirect() {
            return this.equals((Object)INDIRECT);
        }

        public boolean isAttributed() {
            return this.isDirect() || this.isIndirect();
        }

        public boolean isUnattributed() {
            return this.equals((Object)UNATTRIBUTED);
        }

        public boolean isDisabled() {
            return this.equals((Object)DISABLED);
        }

        @NonNull
        public static Session fromString(String value) {
            if (value == null || value.isEmpty()) {
                return UNATTRIBUTED;
            }
            for (Session type : Session.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return UNATTRIBUTED;
        }
    }

    static interface SessionListener {
        public void onSessionEnding(@NonNull SessionResult var1);
    }

    public static class SessionResult {
        @NonNull
        Session session;
        @Nullable
        JSONArray notificationIds;

        SessionResult(@NonNull Builder builder) {
            this.notificationIds = builder.notificationIds;
            this.session = builder.session;
        }

        public static class Builder {
            private JSONArray notificationIds;
            private Session session;

            public static Builder newInstance() {
                return new Builder();
            }

            private Builder() {
            }

            public Builder setNotificationIds(@Nullable JSONArray notificationIds) {
                this.notificationIds = notificationIds;
                return this;
            }

            public Builder setSession(@NonNull Session session) {
                this.session = session;
                return this;
            }

            public SessionResult build() {
                return new SessionResult(this);
            }
        }
    }
}

