/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;

class ActivityLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private static ActivityLifecycleListener instance;
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static ActivityLifecycleHandler activityLifecycleHandler;
    @Nullable
    private static ComponentCallbacks configuration;

    ActivityLifecycleListener() {
    }

    static void registerActivityLifecycleCallbacks(@NonNull Application application) {
        if (instance == null) {
            instance = new ActivityLifecycleListener();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        if (activityLifecycleHandler == null) {
            activityLifecycleHandler = new ActivityLifecycleHandler();
        }
        if (configuration == null) {
            configuration = new ComponentCallbacks(){

                public void onConfigurationChanged(Configuration newConfig) {
                    activityLifecycleHandler.onConfigurationChanged(newConfig, activityLifecycleHandler.getCurActivity());
                }

                public void onLowMemory() {
                }
            };
            application.registerComponentCallbacks(configuration);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.onActivityCreated(activity);
        }
    }

    public void onActivityStarted(Activity activity) {
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.onActivityStarted(activity);
        }
    }

    public void onActivityResumed(Activity activity) {
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.onActivityResumed(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.onActivityPaused(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.onActivityStopped(activity);
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.onActivityDestroyed(activity);
        }
    }

    @Nullable
    public static ActivityLifecycleHandler getActivityLifecycleHandler() {
        return activityLifecycleHandler;
    }
}

